/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.DisplayChunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.IChunkProvider;

public class ChunkProviderViewer
implements IChunkProvider {
    public final Chunk blankChunk;
    public final Chunk displayChunk;

    public ChunkProviderViewer(World world) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.displayChunk = new DisplayChunk(world, 0, 0);
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return true;
    }

    @Override
    public Chunk provideChunk(int chunkX, int chunkZ) {
        if (chunkX == 0 && chunkZ == 0) {
            return this.displayChunk;
        }
        return this.blankChunk;
    }

    @Override
    public Chunk prepareChunk(int chunkX, int chunkZ) {
        if (chunkX == 0 && chunkZ == 0) {
            return this.displayChunk;
        }
        return this.blankChunk;
    }

    @Override
    public void regenerateChunk(int chunkX, int chunkZ) {
    }

    @Override
    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, ProgressListener progressUpdate) {
        return false;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public String getInfoString() {
        return null;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public void setCurrentChunkOver(int chunkX, int chunkZ) {
    }
}

