/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;

public class BlockLogicOreDiamond
extends BlockLogic {
    public static Int2IntArrayMap variantMap = new Int2IntArrayMap();

    public BlockLogicOreDiamond(Block<?> block, Block<?> parentBlock, Material material) {
        super(block, material);
        variantMap.put(parentBlock.id(), block.id());
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
            case EXPLOSION: 
            case PROPER_TOOL: 
            case PISTON_CRUSH: {
                return new ItemStack[]{new ItemStack(Items.DIAMOND)};
            }
        }
        return null;
    }
}

