/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFlag
extends Item {
    public ItemFlag(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        if (this.hasFlagBeenDrawnOn(itemstack) || this.doesFlagContainDyes(itemstack)) {
            return this.getKey() + ".modified";
        }
        return super.getLanguageKey(itemstack);
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack stack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        TileEntityFlag flag;
        if (world.getBlockId(blockX, blockY, blockZ) == Blocks.FLAG.id() && !player.isSneaking() && (flag = (TileEntityFlag)world.getTileEntity(blockX, blockY, blockZ)) != null) {
            CompoundTag flagData = stack.getData().getCompoundOrDefault("FlagData", new CompoundTag());
            if (this.hasFlagBeenDrawnOn(stack) && this.doesFlagContainDyes(stack)) {
                player.sendStatusMessage(I18n.getInstance().translateKey("flag.overwrite"));
                return false;
            }
            flag.copyFlagNBT(flagData);
            UUIDHelper.writeToTag(flagData, player.uuid, "OwnerUUID");
            stack.getData().putCompound("FlagData", flagData);
            player.sendStatusMessage(I18n.getInstance().translateKey("flag.copied"));
            return true;
        }
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (!Blocks.SIGN_POST_PLANKS_OAK.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.FLAG, EnumBlockSoundEffectType.PLACE);
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.FLAG.id(), 0);
        stack.consumeItem(player);
        TileEntityFlag tileEntityFlag = (TileEntityFlag)world.getTileEntity(blockX, blockY, blockZ);
        if (tileEntityFlag != null) {
            CompoundTag flagData = stack.getData().getCompoundOrDefault("FlagData", null);
            if (flagData != null) {
                tileEntityFlag.readAdditionalData(flagData);
            }
            if (!world.isClientSide && tileEntityFlag.owner == null) {
                player.displayFlagEditorScreen(tileEntityFlag);
            }
        }
        return true;
    }

    public boolean hasFlagBeenDrawnOn(ItemStack stack) {
        CompoundTag flagData = stack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        byte[] colors = flagData.getByteArray("Colors");
        if (colors == null) {
            return false;
        }
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean doesFlagContainDyes(ItemStack stack) {
        CompoundTag flagData = stack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        ListTag items = flagData.getList("Items");
        return items != null && items.tagCount() > 0;
    }
}

