/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.container.ScreenInventory;
import net.minecraft.client.gui.options.OptionsButtonElement;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScreenInventoryCreative
extends ScreenInventory
implements TextFieldElement.ITextChangeListener {
    protected ButtonElement lastPageButton;
    protected ButtonElement nextPageButton;
    protected ButtonElement clearSearchButton;
    protected TextFieldElement searchField;
    protected MenuInventoryCreative container;
    protected String pageString = "1/1";

    public ScreenInventoryCreative(Player entityplayer) {
        super(entityplayer);
        this.xSize = 298;
        this.container = (MenuInventoryCreative)entityplayer.inventorySlots;
        this.armourValuesFloat = 186;
        this.armourButtonFloatX = 81;
        this.overlayButtonsLayout.setOffset(-(this.xSize / 2), -(this.ySize / 2) - 10);
    }

    @Override
    public void init() {
        super.init();
        this.lastPageButton = new ButtonElement(500, 0, 0, 20, 20, "<");
        this.buttons.add(this.lastPageButton);
        this.nextPageButton = new ButtonElement(501, 0, 0, 20, 20, ">");
        this.buttons.add(this.nextPageButton);
        this.clearSearchButton = new OptionsButtonElement(0, 0, 10, 12, 20, "").setTextures("minecraft:gui/screen/creative/clear", "minecraft:gui/screen/creative/clear_highlighted", null);
        this.buttons.add(this.clearSearchButton);
        this.searchField = new TextFieldElement(this, this.fontRenderer, 0, 0, 96, 18, this.container.searchText, I18n.getInstance().translateKey("gui.inventory.creative.label.search"));
        this.searchField.drawBackground = false;
        this.searchField.setMaxStringLength(14);
        this.searchField.setTextChangeListener(this);
        this.updatePageSwitcher();
        Keyboard.enableRepeatEvents(true);
    }

    public void scroll(int direction) {
        if (direction == 0) {
            return;
        }
        int count = 1;
        if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
            count = 10;
            if (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                count = 100;
            }
        }
        while (this.lastPageButton.enabled && direction > 0 && count > 0) {
            this.container.lastPage();
            this.updatePageSwitcher();
            --count;
        }
        while (this.nextPageButton.enabled && direction < 0 && count > 0) {
            this.container.nextPage();
            this.updatePageSwitcher();
            --count;
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.searchField.updateCursorCounter();
    }

    @Override
    public void removed() {
        super.removed();
        Keyboard.enableRepeatEvents(false);
    }

    protected void updatePageSwitcher() {
        this.lastPageButton.enabled = this.container.page != 0;
        this.nextPageButton.enabled = this.container.page != this.container.maxPage;
        this.pageString = this.container.page + 1 + "/" + (this.container.maxPage + 1);
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        super.buttonClicked(button);
        if (!button.enabled) {
            return;
        }
        if (button == this.lastPageButton) {
            this.scroll(1);
        } else if (button == this.nextPageButton) {
            this.scroll(-1);
        } else if (button == this.clearSearchButton) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                int i = 0;
                while (i < this.container.inventory.getContainerSize() + this.container.craftSlots.getContainerSize() + this.container.resultSlots.getContainerSize()) {
                    this.mc.playerController.handleInventoryMouseClick(this.container.containerId, InventoryAction.CREATIVE_DELETE, new int[]{i++}, this.mc.thePlayer);
                }
            } else {
                this.searchField.setText("");
                this.container.searchPage("");
                this.updatePageSwitcher();
            }
        }
        this.updatePageSwitcher();
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
        this.searchField.updateCursor(this.mc, mx, my);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.searchField.mouseClicked(mx, my, buttonNum);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (this.searchField.isFocused && eventKey != Keyboard.KEY_ESCAPE) {
            this.searchField.textboxKeyTyped(eventCharacter, eventKey);
            this.container.searchPage(this.searchField.getText());
            this.updatePageSwitcher();
        } else if (!this.searchField.isFocused && eventCharacter == 't') {
            this.searchField.setFocused(true);
        } else {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        this.drawStringCenteredNoShadow(this.fontRenderer, this.pageString, 238, 146, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        this.scroll(Mouse.getDWheel());
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/creative.png").bind();
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.lastPageButton.xPosition = x + 182;
        this.lastPageButton.yPosition = y + 140;
        this.nextPageButton.xPosition = x + 272;
        this.nextPageButton.yPosition = y + 140;
        this.clearSearchButton.xPosition = x + 280;
        this.clearSearchButton.yPosition = y + 6;
        this.searchField.xPosition = x + 183;
        this.searchField.yPosition = y + 7;
        this.drawTexturedModalRect((double)x, (double)y, 0, 0, this.xSize, this.ySize, this.xSize / 2, this.ySize / 2);
        GL11.glEnable(32826);
        GL11.glEnable(2903);
        GL11.glEnable(2929);
        GL11.glPushMatrix();
        GL11.glTranslatef(x + 51, y + 75, 50.0f);
        float f1 = 30.0f;
        GL11.glScalef(-f1, f1, f1);
        GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        float f2 = this.mc.thePlayer.yBodyRot;
        float f3 = this.mc.thePlayer.yRot;
        float f4 = this.mc.thePlayer.xRot;
        float f5 = (float)(x + 51) - this.xSize_lo;
        float f6 = (float)(y + 75 - 50) - this.ySize_lo;
        GL11.glRotatef(135.0f, 0.0f, 1.0f, 0.0f);
        Lighting.enableLight();
        GL11.glRotatef(-135.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-((float)Math.atan(f6 / 40.0f)) * 20.0f, 1.0f, 0.0f, 0.0f);
        this.mc.thePlayer.yBodyRot = (float)Math.atan(f5 / 40.0f) * 20.0f;
        this.mc.thePlayer.yRot = (float)Math.atan(f5 / 40.0f) * 40.0f;
        this.mc.thePlayer.xRot = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        this.mc.thePlayer.entityBrightness = 1.0f;
        GL11.glTranslatef(0.0f, this.mc.thePlayer.heightOffset, 0.0f);
        EntityRenderDispatcher.instance.viewLerpYaw = 180.0f;
        EntityRenderer.renderShadows = false;
        EntityRenderDispatcher.instance.renderEntityPreviewWithPosYaw(Tessellator.instance, this.mc.thePlayer, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        EntityRenderer.renderShadows = true;
        this.mc.thePlayer.entityBrightness = 0.0f;
        this.mc.thePlayer.yBodyRot = f2;
        this.mc.thePlayer.yRot = f3;
        this.mc.thePlayer.xRot = f4;
        GL11.glPopMatrix();
        Lighting.disable();
        GL11.glDisable(32826);
        this.searchField.drawTextBox();
    }

    @Override
    public void textChanged(TextFieldElement textField) {
        this.container.searchPage(textField.getText());
        this.updatePageSwitcher();
    }

    @Override
    public void guiSpecificControllerInput(ControllerInput controller) {
        if (controller.buttonLeftShoulder.pressedThisFrame()) {
            this.scroll(1);
        }
        if (controller.buttonRightShoulder.pressedThisFrame()) {
            this.scroll(-1);
        }
        super.guiSpecificControllerInput(controller);
    }
}

