/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeFX {
    public final WorldType worldType;
    private boolean hasClouds = true;
    private boolean hasSky = true;
    private boolean hasGround = true;
    private boolean hasAurora = false;
    private Float cloudHeight = null;

    public WorldTypeFX(WorldType worldType) {
        this.worldType = worldType;
    }

    public WorldTypeFX setHasClouds(boolean flag) {
        this.hasClouds = flag;
        return this;
    }

    public WorldTypeFX setHasSky(boolean flag) {
        this.hasSky = flag;
        return this;
    }

    public WorldTypeFX setHasGround(boolean flag) {
        this.hasGround = flag;
        return this;
    }

    public WorldTypeFX setHasAurora(boolean flag) {
        this.hasAurora = flag;
        return this;
    }

    public WorldTypeFX setCloudHeight(float cloudHeight) {
        this.cloudHeight = Float.valueOf(cloudHeight);
        return this;
    }

    public boolean hasClouds() {
        return this.hasClouds;
    }

    public boolean hasSky() {
        return this.hasSky;
    }

    public float getCloudHeight() {
        if (this.cloudHeight == null) {
            return this.worldType.getMaxY() + 1 - 20;
        }
        return this.cloudHeight.floatValue();
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public boolean hasAurora() {
        return this.hasAurora;
    }

    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        return Vec3.getTempVec3(1.0, 1.0, 1.0);
    }

    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    public void playerAnimationTick(World world, Player player) {
    }
}

