/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import org.jetbrains.annotations.Nullable;

public class Dimension {
    public int id;
    public final String languageKey;
    public final Dimension homeDim;
    public final WorldType defaultWorldType;
    public final float worldScale;
    @Nullable
    public final Block<? extends BlockLogicPortal> portalBlock;
    private static final Int2ObjectMap<Dimension> dimensionList = new Int2ObjectArrayMap<Dimension>();
    private static final Int2ObjectMap<Dimension> dimensionListUnmodifiable = Int2ObjectMaps.unmodifiable(dimensionList);
    public static final Dimension OVERWORLD = new Dimension("overworld", null, 1.0f, null, WorldTypes.OVERWORLD_DEFAULT);
    public static final Dimension NETHER = new Dimension("nether", OVERWORLD, 0.125f, Blocks.PORTAL_NETHER, WorldTypes.NETHER_DEFAULT);
    public static final Dimension DRIFT = new Dimension("drift", OVERWORLD, 8.0f, Blocks.PORTAL_DRIFT, WorldTypes.DRIFT_DEFAULT);

    public Dimension(String languageKey, Dimension homeDim, float worldScale, @Nullable Block<? extends BlockLogicPortal> portalBlock, WorldType defaultWorldType) {
        this.languageKey = languageKey;
        this.homeDim = homeDim;
        this.worldScale = worldScale;
        this.portalBlock = portalBlock;
        this.defaultWorldType = defaultWorldType;
    }

    public DimensionData getDimensionData(World world) {
        if (world.dimension == this) {
            return world.dimensionData;
        }
        DimensionData dimensionData = world.saveHandler.getDimensionData(this.id);
        if (dimensionData == null) {
            dimensionData = new DimensionData(this.defaultWorldType);
        }
        return dimensionData;
    }

    public boolean canPortal(Dimension dim) {
        if (this.homeDim == null) {
            return true;
        }
        return dim == this.homeDim;
    }

    public static float getCoordScale(Dimension oldDim, Dimension newDim) {
        if (oldDim.homeDim == newDim) {
            return 1.0f / oldDim.worldScale;
        }
        if (newDim.homeDim == oldDim) {
            return newDim.worldScale;
        }
        return 1.0f;
    }

    public String getTranslatedName() {
        return I18n.getInstance().translateKey("dimension." + this.languageKey + ".name");
    }

    public String toString() {
        return "Dimension: [ ID: " + this.id + " Name: " + this.getTranslatedName() + " ]";
    }

    public static Int2ObjectMap<Dimension> getDimensionList() {
        return dimensionListUnmodifiable;
    }

    public static void registerDimension(int id, Dimension dimension) throws IllegalArgumentException {
        if (dimensionList.containsKey(id)) {
            throw new IllegalArgumentException("Dimension with ID " + id + " is already registered!");
        }
        dimension.id = id;
        dimensionList.put(id, dimension);
    }

    public static void init() {
        Dimension.registerDimension(0, OVERWORLD);
        Dimension.registerDimension(1, NETHER);
        Dimension.registerDimension(2, DRIFT);
    }
}

