/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelCandle<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelCandle(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        boolean isLit = (worldSource.getBlockMetadata(x, y, z) & 1) == 0;
        float brightness = isLit ? 1.0f : renderBlocks.getBlockBrightness(worldSource, x, y, z);
        float minX = (float)x + 0.5f - 0.09375f;
        float minY = (float)y + 0.0f;
        float minZ = (float)z + 0.5f - 0.09375f;
        float maxX = (float)x + 0.5f + 0.09375f;
        float maxY = (float)y + 0.5f;
        float maxZ = (float)z + 0.5f + 0.09375f;
        float wickMaxY = maxY + 0.375f;
        IconCoordinate texIndex = this.getParticleTexture(Side.TOP, 0);
        if (BlockModelCandle.renderBlocks.overrideBlockTexture != null) {
            texIndex = BlockModelCandle.renderBlocks.overrideBlockTexture;
        }
        double texU = texIndex.getIconUMin();
        double texV = texIndex.getIconVMin();
        double onePix = 0.0625;
        double uOffset = isLit ? 0.0 : onePix * 3.0;
        double sideMinU = texIndex.getSubIconU(uOffset);
        double sideMaxU = texIndex.getSubIconU(uOffset + onePix * 3.0);
        double sideMinV = texIndex.getSubIconV(onePix * 3.0);
        double sideMaxV = texIndex.getSubIconV(onePix * 3.0 + onePix * 8.0);
        double topMinU = texIndex.getSubIconU(uOffset);
        double topMaxU = texIndex.getSubIconU(uOffset + onePix * 3.0);
        double topMinV = texV;
        double topMaxV = texIndex.getSubIconV(onePix * 3.0);
        double bottomMinU = texIndex.getSubIconU(onePix * 3.0);
        double bottomMaxU = texIndex.getSubIconU(onePix * 3.0 + onePix * 3.0);
        double bottomMinV = texV;
        double bottomMaxV = texIndex.getSubIconV(onePix * 3.0);
        double wickMinU = texIndex.getSubIconU(onePix * 6.0 + uOffset);
        double wickMaxU = texIndex.getSubIconU(onePix * 6.0 + uOffset + onePix * 3.0);
        double wickMinV = texV;
        double wickMaxV = texIndex.getSubIconV(onePix * 6.0);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(maxX, minY, minZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(minX, minY, minZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, minY, maxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(maxX, minY, minZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, minY, minZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(minX, minY, maxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, minZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, topMinU, topMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, topMaxU, topMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, topMaxU, topMinV);
        tessellator.addVertexWithUV(minX, maxY, minZ, topMinU, topMinV);
        tessellator.addVertexWithUV(minX, minY, minZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(maxX, minY, minZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(minX, minY, maxZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(maxX, wickMaxY, maxZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, minZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, minZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(maxX, wickMaxY, maxZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(maxX, wickMaxY, minZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, maxZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, maxZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(maxX, wickMaxY, minZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, wickMaxU, wickMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

