/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.wire;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.current.util.BlockPos;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.current.util.Mth;
import net.minecraft.core.current.wire.Node;
import net.minecraft.core.current.wire.WireConnectionManager;
import net.minecraft.core.current.wire.WorldHelper;
import net.minecraft.core.world.World;

public class WireNode
extends Node {
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean root;
    boolean discovered;
    boolean searched;
    WireNode next_wire;

    WireNode(World world, BlockPos pos, BlockState state) {
        super(world);
        this.pos = pos;
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.state.get();
        this.priority = this.priority();
    }

    @Override
    Node set(BlockPos pos, BlockState state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    int priority() {
        return Mth.clamp(this.virtualPower, 0, 15);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = WorldHelper.getBlockState(this.world, this.pos);
        if (!this.state.is(Blocks.WIRE_REDSTONE)) {
            return false;
        }
        if (this.shouldBreak) {
            this.state.dropItems(this.world, this.pos);
            this.world.setBlock(this.pos.x, this.pos.y, this.pos.z, 0);
            return true;
        }
        this.currentPower = Mth.clamp(this.virtualPower, 0, 15);
        this.state = this.state.set(this.currentPower);
        return WorldHelper.setWireState(this.world, this.pos, this.state);
    }
}

