/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherClear;
import net.minecraft.core.world.weather.WeatherConfig;
import net.minecraft.core.world.weather.WeatherRain;
import net.minecraft.core.world.weather.WeatherRainBlood;
import net.minecraft.core.world.weather.WeatherSnow;
import net.minecraft.core.world.weather.WeatherStorm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Weathers {
    public static final @Nullable Weather @NotNull [] WEATHERS = new Weather[16];
    @NotNull
    public static final Weather OVERWORLD_CLEAR = new WeatherClear(0, "overworld.clear", new WeatherConfig());
    @NotNull
    public static final Weather OVERWORLD_RAIN = new WeatherRain(1, "overworld.rain", new WeatherConfig().setLightLevelSubtracted(3).setFogDistanceMultiplier(0.5f).setDamp(true));
    @NotNull
    public static final Weather OVERWORLD_SNOW = new WeatherSnow(2, "overworld.snow", new WeatherConfig().setLightLevelSubtracted(1).setFogDistanceMultiplier(0.5f).setDamp(true));
    @NotNull
    public static final Weather OVERWORLD_STORM = new WeatherStorm(3, "overworld.storm", new WeatherConfig().setLightLevelSubtracted(5).setMobDaylightSpawnAllowed(true).setFogDistanceMultiplier(0.4f).setDamp(true));
    @NotNull
    public static final Weather OVERWORLD_FOG = new WeatherClear(4, "overworld.fog", new WeatherConfig().setFogDistanceMultiplier(0.125f));
    @NotNull
    public static final Weather OVERWORLD_HELL_CLEAR = new WeatherClear(5, "overworld.hell.clear", new WeatherConfig().setLightLevelSubtracted(7));
    @NotNull
    public static final Weather OVERWORLD_WOODS_CLEAR = new WeatherClear(6, "overworld.woods.clear", new WeatherConfig().setLightLevelSubtracted(2));
    @NotNull
    public static final Weather OVERWORLD_WINTER_SNOW = new WeatherSnow(7, "overworld.winter.snow", new WeatherConfig().setDamp(true));
    @NotNull
    public static final Weather OVERWORLD_RAIN_BLOOD = new WeatherRainBlood(8, "overworld.rain.blood", new WeatherConfig().setLightLevelSubtracted(5).setMobDaylightSpawnAllowed(true).setFogDistanceMultiplier(0.4f).setDamp(true));

    @Nullable
    public static Weather getWeatherByLanguageKey(@NotNull String languageKey) {
        for (Weather weather : WEATHERS) {
            if (weather == null || !weather.getLanguageKey().substring(8).equalsIgnoreCase(languageKey)) continue;
            return weather;
        }
        return null;
    }

    @Nullable
    public static Weather getWeather(int i) {
        return WEATHERS[i];
    }
}

