/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenConsole;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class Screen
extends Gui {
    @NotNull
    public final Minecraft mc = Minecraft.getMinecraft();
    public int width;
    public int height;
    public List<ButtonElement> buttons;
    public boolean passEvents = false;
    public FontRenderer fontRenderer;
    protected ButtonElement clickedButton = null;
    protected final Screen parentScreen;
    private CursorShape desiredCursor = CursorShape.ARROW;

    public Screen(@Nullable Screen parent) {
        this.buttons = new ArrayList<ButtonElement>();
        this.parentScreen = parent;
    }

    public Screen() {
        this(null);
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }

    public final CursorShape getDesiredCursor() {
        return this.desiredCursor;
    }

    public final void setDesiredCursor(CursorShape desiredCursor) {
        this.desiredCursor = desiredCursor;
    }

    public <E extends ButtonElement> E add(E button) {
        this.buttons.add(button);
        return button;
    }

    public void render(int mx, int my, float partialTick) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonElement button = this.buttons.get(i);
            button.drawButton(this.mc, mx, my);
        }
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_BACK) {
            this.mc.displayScreen(this.parentScreen);
        }
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(null);
        }
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        if (buttonNum == 0) {
            for (ButtonElement button : this.buttons) {
                if (!button.mouseClicked(this.mc, mx, my) || !button.playSound) continue;
                this.clickedButton = button;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                if (button.listener != null) {
                    button.listener.listen(button);
                } else {
                    this.buttonClicked(button);
                }
                return;
            }
        }
    }

    public void mouseReleased(int mx, int my, int buttonNum) {
        if (this.clickedButton != null && buttonNum == 0) {
            this.buttonReleased(this.clickedButton);
            this.clickedButton.mouseReleased(mx, my);
            this.clickedButton = null;
        }
    }

    protected void buttonClicked(ButtonElement button) {
    }

    protected void buttonReleased(ButtonElement button) {
    }

    public void opened(int width, int height) {
        this.fontRenderer = this.mc.font;
        this.width = width;
        this.height = height;
        this.buttons.clear();
        this.init();
    }

    public void init() {
    }

    public void updateEvents() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.getHeightScreenCoords() - 1;
        while (Mouse.next() && this.mc.inputType != InputType.CONTROLLER) {
            if (Mouse.getEventButtonState()) {
                this.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            this.mouseReleased(mouseX, mouseY, Mouse.getEventButton());
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState() && ((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
            int eventKey = Keyboard.getEventKey();
            char eventChar = Keyboard.getEventCharacter();
            if (eventKey == 0 && Character.isDefined(eventChar)) {
                this.keyPressed(eventChar, eventKey, mouseX, mouseY);
                return;
            }
            if (!Keyboard.getEventKeyState()) continue;
            if (eventKey == Keyboard.KEY_F11) {
                this.mc.gameWindow.toggleFullscreen();
                return;
            }
            if (!(this instanceof ScreenConsole) && eventKey == this.mc.gameSettings.keyShowConsole.getKeyCode() && ((Boolean)this.mc.gameSettings.developerMode.value).booleanValue() && !Keyboard.areRepeatEventsEnabled()) {
                this.mc.displayScreen(new ScreenConsole(this));
                return;
            }
            this.keyPressed(eventChar, eventKey, mouseX, mouseY);
        }
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        if (this.mc.currentWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.renderTexturedBackground();
        }
    }

    public void renderTexturedBackground() {
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        Tessellator tessellator = Tessellator.instance;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
    }

    public void drawControllerCursor() {
        if (this.mc.controllerInput.hideCursor) {
            return;
        }
        GL11.glDisable(2929);
        GL11.glEnable(3042);
        GL11.glColor3d(1.0, 1.0, 1.0);
        this.drawGuiTexture(this.mc.textureManager, (int)(this.mc.controllerInput.cursorX - 8.0), (int)(this.mc.controllerInput.cursorY - 8.0), 16, 16, "/assets/minecraft/textures/gui/controller/cursor.png");
        GL11.glDisable(3042);
    }

    public void controllerInput(ControllerInput controller) {
        this.guiSpecificControllerInput(controller);
        this.playControllerButtonSound(controller);
    }

    public void playControllerButtonSound(ControllerInput controller) {
        if (controller.buttonA.pressedThisFrame() || controller.buttonX.pressedThisFrame() || controller.buttonY.pressedThisFrame()) {
            this.mc.sndManager.playSound("ui.ui_click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.sndManager.playSound("ui.ui_back", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    public void guiSpecificControllerInput(ControllerInput controller) {
        this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, -1);
        if (controller.buttonB.pressedThisFrame()) {
            this.keyPressed('\u0000', Keyboard.KEY_BACK, -1, -1);
        }
        if (controller.buttonStart.pressedThisFrame()) {
            this.keyPressed('\u0000', Keyboard.KEY_ESCAPE, -1, -1);
        }
        if (controller.buttonA.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (controller.buttonA.releasedThisFrame()) {
            this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (controller.buttonY.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 1);
        }
        if (controller.buttonY.releasedThisFrame()) {
            this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, 1);
        }
        if (controller.buttonX.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 10);
        }
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void selectNextField() {
    }

    public void updateFont() {
        this.fontRenderer = this.mc.font;
    }
}

