/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.core.util.helper.Toggleable;
import org.jetbrains.annotations.NotNull;

public class OptionFont
extends OptionToggleable<Font>
implements Toggleable {
    public OptionFont(GameSettings gameSettings, String name, @NotNull Font defaultValue) {
        super(gameSettings, name, defaultValue, null);
    }

    @Override
    public void parse(String string) {
        this.value = Fonts.fontWithKey(string);
    }

    @Override
    public void toggle() {
        this.value = Fonts.fontAtIndex((this.getValueIndex() + 1) % this.size());
    }

    @Override
    public void toggle(int delta) {
        this.value = Fonts.fontAtIndex(DynamicTexture.pmod(this.getValueIndex() + delta, this.size()));
    }

    @Override
    public int getValueIndex() {
        return Fonts.indexForFont((Font)this.value);
    }

    @Override
    public void setValueWithIndex(int i) {
        this.value = Fonts.fontAtIndex(i);
    }

    @Override
    public int size() {
        return Fonts.fontAmount();
    }

    @Override
    public boolean isSlider() {
        return true;
    }

    @Override
    public String getValueString() {
        return ((Font)this.value).getKey();
    }
}

