/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public class BlockModelHorizontalRotation<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static final DisplayPos ROTATABLE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos ROTATABLE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -180.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos ROTATABLE_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -45.0f, 0.0f, 0.4f, 0.4f, 0.4f);

    public BlockModelHorizontalRotation(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", ROTATABLE_GUI);
        this.setDisplayPos("head", ROTATABLE_HEAD);
        this.setDisplayPos("firstperson_righthand", ROTATABLE_FIRST_PERSON_RIGHT_HAND);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(data & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.overbrightTextures.get(Side.BOTTOM);
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(Side.getSideById(index), data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(data & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        return super.getBlockTextureFromSideAndMetadata(Side.getSideById(index), data);
    }
}

