/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.BlockLogicSignPainted;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private final Minecraft mc = Minecraft.getMinecraft();
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    private final String[] signColorTextures = new String[16];
    private final BufferedTextMeshRenderer textMeshRenderer = new BufferedTextMeshRenderer();

    public TileEntityRendererSign() {
        for (int i = 0; i < this.signColorTextures.length; ++i) {
            this.signColorTextures[i] = "/assets/minecraft/textures/entity/sign/" + DyeColor.colorFromBlockMeta((int)i).colorID + ".png";
        }
    }

    @Override
    public void doRender(@NotNull Tessellator t, @NotNull TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        int colorSign;
        float height;
        StaticEntityModel model;
        float angle;
        Block<?> block = tileEntity.getBlock();
        if (block == null || !(block.getLogic() instanceof BlockLogicSign)) {
            return;
        }
        GL11.glEnable(32826);
        GL11.glPushMatrix();
        float scale = 0.041666668f;
        GL11.glTranslatef((float)x + 0.5f, (float)y, (float)z + 0.5f);
        int meta = tileEntity.getBlockMeta();
        if (((BlockLogicSign)block.getLogic()).isFreeStanding) {
            angle = (float)((meta & 0xF) * 360) / 16.0f;
            GL11.glRotatef(-angle, 0.0f, 1.0f, 0.0f);
            model = this.getModel("post");
            height = 20.0f;
        } else {
            switch (meta & 0xF) {
                case 2: {
                    angle = 180.0f;
                    break;
                }
                case 3: {
                    angle = 0.0f;
                    break;
                }
                case 4: {
                    angle = 90.0f;
                    break;
                }
                default: {
                    angle = -90.0f;
                }
            }
            GL11.glRotatef(-angle, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, 0.0f, -0.45833334f);
            model = this.getModel("wall");
            height = 13.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef(0.041666668f, 0.041666668f, -0.041666668f);
        if (Block.hasLogicClass(block, BlockLogicSignPainted.class)) {
            DyeColor c = ((IPainted)block.getLogic()).fromMetadata(meta);
            this.bindTexture(this.signColorTextures[c.blockMeta]);
            colorSign = c.color.getARGB();
        } else {
            this.bindTexture("/assets/minecraft/textures/entity/sign.png");
            colorSign = 6905411;
        }
        GL11.glDisable(3042);
        model.render(t);
        GL11.glEnable(3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glEnable(3042);
        GL11.glTranslatef(0.0f, height * 0.041666668f, 0.04375f);
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glDepthMask(false);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        EnumSignPicture picture = tileEntity.getPicture();
        if (picture != EnumSignPicture.NONE) {
            TileEntityRendererSign.drawTexturedModalRect(1.0, 0.5, colorSign, TextureRegistry.getTexture(picture.getTextureKey()));
        }
        GL11.glDisable(3042);
        GL11.glPopMatrix();
        FontRenderer sr = this.getFont();
        float lightLevel = LightmapHelper.isLightmapEnabled() || this.mc.isFullbrightEnabled() ? 1.0f : this.mc.currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightLevel = 1.0f;
            lightOffset = 96.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
        }
        GL11.glPushMatrix();
        float scale2 = 0.011111113f;
        GL11.glTranslatef(0.0f, height * 0.041666668f, 0.045833334f);
        GL11.glScalef(0.011111113f, -0.011111113f, 0.011111113f);
        GL11.glDepthMask(false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)Color.redFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)Color.greenFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)Color.blueFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        color = Color.intToIntARGB(0, r, g, b);
        CharSequence line1 = tileEntity.signText[0];
        CharSequence line2 = tileEntity.signText[1];
        CharSequence line3 = tileEntity.signText[2];
        CharSequence line4 = tileEntity.signText[3];
        switch (tileEntity.lineBeingEdited) {
            case 0: {
                this.builder.setLength(0);
                line1 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line1).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 1: {
                this.builder.setLength(0);
                line2 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line2).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 2: {
                this.builder.setLength(0);
                line3 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line3).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 3: {
                this.builder.setLength(0);
                line4 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line4).append("\u00a7+\u00a7f <\u00a7-");
            }
        }
        boolean _x = false;
        int _y = -tileEntity.signText.length * 5;
        if (tileEntity.isGlowing() && (Integer)this.mc.gameSettings.fancyGraphics.value >= 1) {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, _y, SF.setOutlined(SF.setColor(0L, color)));
        } else {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, _y, SF.setColor(0L, color));
        }
        GL11.glPopMatrix();
        GL11.glDepthMask(true);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPopMatrix();
        GL11.glDisable(32826);
    }

    private static void drawTexturedModalRect(double width, double height, int color, @NotNull IconCoordinate coordinate) {
        if (coordinate == null) {
            return;
        }
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(color, 128);
        tessellator.addVertexWithUV(-width / 2.0, height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }

    @Override
    public void tick() {
        this.textMeshRenderer.tick();
    }

    @Override
    public void onWorldChanged(World world) {
        this.textMeshRenderer.flushCaches();
    }

    @Override
    public boolean isVisible(@NotNull TileEntitySign tileEntity, @NotNull ICamera camera, float partialTick) {
        return camera.getFrustum().isVisible(AABB.getTemporaryBB(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.x + 1, tileEntity.y + 1, tileEntity.z + 1), partialTick);
    }

    public static class BufferedTextMeshRenderer {
        private static final long MAX_NON_RENDERED_TIME = 120000L;
        @NotNull
        private final IntList freeDisplayLists = new IntArrayList();
        @NotNull
        private final @NotNull List<@NotNull MeshEntry> bufferedMeshes = new ArrayList<MeshEntry>();
        @NotNull
        private final MeshEntry referenceEntry = new MeshEntry("", "", "", "", 0L);

        public void tick() {
            Iterator<MeshEntry> iterator = this.bufferedMeshes.iterator();
            while (iterator.hasNext()) {
                MeshEntry entry = iterator.next();
                if (System.currentTimeMillis() - entry.lastUse <= 120000L) continue;
                assert (entry.list != -1);
                this.freeDisplayLists.add(entry.list);
                iterator.remove();
            }
        }

        public void flushCaches() {
            for (MeshEntry entry : this.bufferedMeshes) {
                GLAllocation.deleteDisplayList(entry.list);
            }
            this.bufferedMeshes.clear();
            IntListIterator intListIterator = this.freeDisplayLists.iterator();
            while (intListIterator.hasNext()) {
                int list = (Integer)intListIterator.next();
                GLAllocation.deleteDisplayList(list);
            }
            this.freeDisplayLists.clear();
        }

        public void render(@NotNull FontRenderer sr, @NotNull Tessellator t, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, int x, int y, long config) {
            GL11.glPushMatrix();
            GL11.glTranslatef(x, y, 0.0f);
            this.renderInternal(sr, t, line1, line2, line3, line4, config);
            GL11.glPopMatrix();
        }

        private void renderInternal(@NotNull FontRenderer sr, @NotNull Tessellator t, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
            this.referenceEntry.line1 = line1.toString();
            this.referenceEntry.line2 = line2.toString();
            this.referenceEntry.line3 = line3.toString();
            this.referenceEntry.line4 = line4.toString();
            this.referenceEntry.config = config;
            MeshEntry entry = null;
            int size = this.bufferedMeshes.size();
            for (int i = 0; i < size; ++i) {
                MeshEntry e = this.bufferedMeshes.get(i);
                if (!this.referenceEntry.equals(e)) continue;
                entry = e;
                break;
            }
            if (entry != null) {
                entry.lastUse = System.currentTimeMillis();
                GL11.glCallList(entry.list);
            } else {
                entry = new MeshEntry(line1, line2, line3, line4, config);
                entry.lastUse = System.currentTimeMillis();
                entry.list = this.getDisplayList();
                GL11.glNewList(entry.list, 4864);
                sr.render(t, line1, -sr.stringWidth(line1) / 2, 0).setConfig(config).call();
                sr.render(t, line2, -sr.stringWidth(line2) / 2, 10).setConfig(config).call();
                sr.render(t, line3, -sr.stringWidth(line3) / 2, 20).setConfig(config).call();
                sr.render(t, line4, -sr.stringWidth(line4) / 2, 30).setConfig(config).call();
                GL11.glEndList();
                GL11.glCallList(entry.list);
                this.bufferedMeshes.add(entry);
            }
        }

        private int getDisplayList() {
            if (this.freeDisplayLists.isEmpty()) {
                return GLAllocation.generateDisplayLists(1);
            }
            return this.freeDisplayLists.removeInt(0);
        }

        public static class MeshEntry {
            public long config;
            @NotNull
            public String line1;
            @NotNull
            public String line2;
            @NotNull
            public String line3;
            @NotNull
            public String line4;
            public long lastUse = 0L;
            public int list = -1;

            public MeshEntry(@NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
                this.config = config;
                this.line1 = line1.toString();
                this.line2 = line2.toString();
                this.line3 = line3.toString();
                this.line4 = line4.toString();
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MeshEntry entry = (MeshEntry)o;
                return this.config == entry.config && this.line1.equals(entry.line1) && this.line2.equals(entry.line2) && this.line3.equals(entry.line3) && this.line4.equals(entry.line4);
            }

            public int hashCode() {
                int result = Long.hashCode(this.config);
                result = 31 * result + this.line1.hashCode();
                result = 31 * result + this.line2.hashCode();
                result = 31 * result + this.line3.hashCode();
                result = 31 * result + this.line4.hashCode();
                return result;
            }
        }
    }
}

