/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryArmoredZombie;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryBoat;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryCreeper;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryDispatcher;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryFallingBlock;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryFirefly;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryItem;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryMinecart;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryPainting;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntrySheep;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntrySlime;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryTNT;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntryWolf;
import net.minecraft.client.gui.modelviewer.elements.ListenerTextFieldElement;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ViewerCategoryEntity
extends ModelViewerCategory<ModelViewerCategory.Info> {
    public HashMap<Class<? extends Entity>, EntityEntry<?>> entryMap = new HashMap();
    public List<EntityEntry<?>> entryList = new ArrayList();
    public ListenerTextFieldElement entityName;
    public TextCycleElement<Integer> entityVariant;
    public EntityEntry<?> currentEntry = EntityEntry.blankEntry;
    public Entity displayEntity;

    public ViewerCategoryEntity(ScreenModelViewer modelViewer) {
        super(modelViewer);
        this.createEntries();
    }

    public void createEntries() {
        for (NamespaceID id : EntityDispatcher.idToClassMap.keySet()) {
            try {
                this.addEntry(new EntityEntryDispatcher(id));
            }
            catch (Exception exception) {}
        }
        this.addEntry(new EntityEntryItem());
        this.addEntry(new EntityEntryFirefly());
        this.addEntry(new EntityEntrySheep());
        this.addEntry(new EntityEntryWolf());
        this.addEntry(new EntityEntryCreeper());
        this.addEntry(new EntityEntryArmoredZombie());
        this.addEntry(new EntityEntrySlime());
        this.addEntry(new EntityEntryMinecart());
        this.addEntry(new EntityEntryBoat());
        this.addEntry(new EntityEntryFallingBlock());
        this.addEntry(new EntityEntryTNT());
        this.addEntry(new EntityEntryPainting());
    }

    public void addEntry(EntityEntry<?> entry) {
        Object entity = entry.getEntityInstance(this.mc, this.mc.currentWorld);
        if (entity == null) {
            return;
        }
        EntityEntry<?> oldEntry = this.entryMap.put(entity.getClass(), entry);
        this.entryList.remove(oldEntry);
        this.entryList.add(entry);
    }

    public <V extends Entity> EntityEntry<V> getEntry(V entity) {
        return this.entryMap.getOrDefault(entity.getClass(), EntityEntry.blankEntry);
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.entity.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        String title = "None";
        if (this.displayEntity != null) {
            title = EntityDispatcher.idForClass(this.displayEntity.getClass()).toString();
        }
        return translator.translateKeyAndFormat("model.category.entity.info", title);
    }

    @Override
    public void addContextButtons(List<ButtonElement> buttonList) {
        ButtonElement lastButton = buttonList.get(buttonList.size() - 1);
        boolean isLiving = this.displayEntity instanceof Mob;
        if (isLiving) {
            this.entityVariant = new TextCycleElement<Integer>((Screen)this.modelViewer, this.mc.font, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, Integer.valueOf(0)){

                @Override
                public Integer cycleElement(Integer current, int offset) {
                    return current + offset & 0xFF;
                }

                @Override
                public Integer getElementFromString(String s) {
                    try {
                        int id = Integer.parseInt(s);
                        return MathHelper.clamp(id, 0, 127);
                    }
                    catch (Exception exception) {
                        return ViewerCategoryEntity.this.displayEntity.getEntityData().getByte(1);
                    }
                }

                @Override
                public String getNameFromElement(Integer element) {
                    return String.valueOf(element);
                }
            };
            this.entityVariant.setOnValueChanged(() -> ((Mob)this.displayEntity).setSkinVariant(this.entityVariant.getCurrentElement()));
            this.entityVariant.textField.setPlaceholder("Variant");
            this.entityVariant.textField.setPrefaceText("Variant: ");
            buttonList.add(this.entityVariant);
            this.entityName = new ListenerTextFieldElement(this.modelViewer, this.mc.font, this.modelViewer.width - 120, this.entityVariant.yPosition + 21, 120, 20, "", "Nickname");
            this.entityName.setTextChangeListener(this.modelViewer);
            buttonList.add(this.entityName);
        }
        lastButton = buttonList.get(buttonList.size() - 1);
        int xPos = this.modelViewer.width;
        int yPos = lastButton.getY() + lastButton.getHeight() + 1;
        List<ButtonElement> entryButtons = this.getEntry(this.displayEntity).getEntryButtons(this.mc, this.modelViewer, this.displayEntity);
        if (entryButtons != null) {
            for (ButtonElement button : entryButtons) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(entryButtons);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
        int id = 0;
        ArrayList _val = new ArrayList(this.entryList);
        if (this.currentEntry != EntityEntry.blankEntry) {
            id = _val.indexOf(this.currentEntry);
        }
        this.currentEntry.onClose();
        this.currentEntry = (EntityEntry)_val.get((id + _val.size() + offset) % _val.size());
        this.currentEntry.onOpen();
        this.setDisplayEntity((Entity)this.currentEntry.getEntityInstance(this.mc, this.mc.currentWorld));
    }

    @Override
    public void onOpen() {
        this.currentEntry = this.entryMap.get(MobZombie.class);
        this.currentEntry.onOpen();
        this.setDisplayEntity((Entity)this.currentEntry.getEntityInstance(this.mc, this.mc.currentWorld));
    }

    @Override
    public void onClose() {
        this.currentEntry.onClose();
        this.removeDisplayEntity();
    }

    @Override
    public void onTick() {
        String oldNick;
        if (this.displayEntity != null) {
            ++this.displayEntity.tickCount;
            this.getEntry(this.displayEntity).onTick(this.displayEntity);
        }
        if (!(this.displayEntity instanceof MobHuman && System.currentTimeMillis() <= this.modelViewer.timeLastKeyPressed + 1000L || this.displayEntity == null || !(this.displayEntity instanceof Mob) || (oldNick = ((Mob)this.displayEntity).nickname).equals(this.entityName.getText()))) {
            ((Mob)this.displayEntity).setNickname(this.entityName.getText());
        }
    }

    @Override
    public void queueBulkRender(@NotNull File outputDir, List<ModelViewerCategory.Info> renderInfos) {
    }

    @Override
    public void setupRender(ModelViewerCategory.Info info) {
    }

    public void setDisplayEntity(Entity entity) {
        this.removeDisplayEntity();
        this.displayEntity = entity;
        if (this.displayEntity != null) {
            this.displayEntity.noPhysics = true;
            this.displayEntity.absMoveTo(this.mc.thePlayer.x, this.mc.thePlayer.y + (double)this.mc.thePlayer.getHeadHeight() - (double)(this.displayEntity.bbHeight / 2.0f), this.mc.thePlayer.z, this.displayEntity.yRot, this.displayEntity.xRot);
            this.displayEntity.lerpMotion(0.0, 0.0, 0.0);
            this.mc.currentWorld.entityJoinedWorld(this.displayEntity);
            if (this.displayEntity instanceof Mob) {
                ((Mob)this.displayEntity).setSkinVariant(0);
            }
        }
        this.mc.particleEngine.setWorld(this.mc.currentWorld);
        this.modelViewer.init();
    }

    public void removeDisplayEntity() {
        if (this.displayEntity != null) {
            this.displayEntity.remove();
            this.mc.currentWorld.loadedEntityList.remove(this.displayEntity);
        }
        this.mc.particleEngine.setWorld(this.mc.currentWorld);
    }
}

