/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureCrystalCone
extends WorldFeature {
    private final boolean ceilingGen;

    public WorldFeatureCrystalCone(boolean ceilingGen) {
        this.ceilingGen = ceilingGen;
    }

    protected void assignValue(int x, int y, int z, int id, int meta, World world) {
        world.setBlockAndMetadata(x, y, z, id, meta);
    }

    protected void crossSection(int[] center, double radius, int dirAxis, int id, int data, World world) {
        int rad = MathHelper.floor(radius + 0.618);
        int secidx1 = (dirAxis + 1) % 3;
        int secidx2 = (dirAxis + 2) % 3;
        int[] coord = new int[3];
        for (int off1 = -rad; off1 < rad + 1; ++off1) {
            for (int off2 = -rad; off2 < rad + 1; ++off2) {
                double thisDist = Math.sqrt(Math.pow((double)Math.abs(off1) + 0.5, 2.0) + Math.pow((double)Math.abs(off2) + 0.5, 2.0));
                if (thisDist > radius) continue;
                int pri = center[dirAxis];
                int sec1 = center[secidx1] + off1;
                int sec2 = center[secidx2] + off2;
                coord[dirAxis] = pri;
                coord[secidx1] = sec1;
                coord[secidx2] = sec2;
                this.assignValue(coord[0], coord[1], coord[2], id, data, world);
            }
        }
    }

    protected void taperedLimb(int[] start, int[] end, double startSize, double endSize, World world) {
        int secidx1;
        int[] delta = new int[]{end[0] - start[0], end[1] - start[1], end[2] - start[2]};
        int maxDist = MathHelper.maxAbs(delta[0], MathHelper.maxAbs(delta[1], delta[2]));
        if (maxDist == 0) {
            return;
        }
        int primidx = 0;
        for (int i = 0; i < 3; ++i) {
            if (delta[i] != maxDist) continue;
            primidx = i;
            break;
        }
        if ((secidx1 = (primidx - 1) % 3) < 0) {
            secidx1 += 3;
        }
        int secidx2 = (1 + primidx) % 3;
        int primSign = delta[primidx] / Math.abs(delta[primidx]);
        int secdelta1 = delta[secidx1];
        float secfac1 = (float)secdelta1 / (float)delta[primidx];
        int secdelta2 = delta[secidx2];
        float secfac2 = (float)secdelta2 / (float)delta[primidx];
        int[] coord = new int[3];
        int endOffset = delta[primidx] + primSign;
        int endOffsetAbs = Math.abs(endOffset);
        int iterator = Math.abs(primSign);
        for (int primOffsetAbs = 0; primOffsetAbs < endOffsetAbs; primOffsetAbs += iterator) {
            int primOffset = primOffsetAbs * primSign;
            int primLoc = start[primidx] + primOffset;
            int secloc1 = (int)((float)start[secidx1] + (float)primOffset * secfac1);
            int secloc2 = (int)((float)start[secidx2] + (float)primOffset * secfac2);
            coord[primidx] = primLoc;
            coord[secidx1] = secloc1;
            coord[secidx2] = secloc2;
            int primDist = Math.abs(delta[primidx]);
            double radius = endSize + (startSize - endSize) * (double)Math.abs(delta[primidx] - primOffset) / (double)primDist;
            this.crossSection(coord, radius, primidx, Blocks.CRYSTAL.id(), 0, world);
        }
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int x1 = x + random.nextInt(2) - random.nextInt(2);
        int z1 = z + random.nextInt(2) - random.nextInt(2);
        int yF = y;
        int radius = 5;
        int checksForGround = 0;
        boolean canGenerate = false;
        while (true) {
            int blockId = this.ceilingGen ? world.getBlockId(x1, yF + 1, z1) : world.getBlockId(x1, yF - 1, z1);
            if (checksForGround > 64 || yF <= 0 || yF >= world.getHeightBlocks()) break;
            if (Blocks.solid[blockId]) {
                canGenerate = true;
                break;
            }
            yF = this.ceilingGen ? ++yF : --yF;
            ++checksForGround;
        }
        if (canGenerate && world.isAirBlock(x1, yF, z1)) {
            int rand = random.nextInt(4);
            if (this.ceilingGen) {
                switch (rand) {
                    case 0: {
                        this.taperedLimb(new int[]{x1, yF + 2, z1}, new int[]{x1 + 24, yF - 24, z1}, radius, 1.0, world);
                        break;
                    }
                    case 1: {
                        this.taperedLimb(new int[]{x1, yF + 2, z1}, new int[]{x1 - 24, yF - 24, z1}, radius, 1.0, world);
                        break;
                    }
                    case 2: {
                        this.taperedLimb(new int[]{x1, yF + 2, z1}, new int[]{x1, yF - 24, z1 + 24}, radius, 1.0, world);
                        break;
                    }
                    case 3: {
                        this.taperedLimb(new int[]{x1, yF + 2, z1}, new int[]{x1, yF - 24, z - 24}, radius, 1.0, world);
                    }
                }
            } else {
                switch (rand) {
                    case 0: {
                        this.taperedLimb(new int[]{x1, yF - 2, z1}, new int[]{x1 + 24, yF + 24, z1}, radius, 1.0, world);
                        break;
                    }
                    case 1: {
                        this.taperedLimb(new int[]{x1, yF - 2, z1}, new int[]{x1 - 24, yF + 24, z1}, radius, 1.0, world);
                        break;
                    }
                    case 2: {
                        this.taperedLimb(new int[]{x1, yF - 2, z1}, new int[]{x1, yF + 24, z1 + 24}, radius, 1.0, world);
                        break;
                    }
                    case 3: {
                        this.taperedLimb(new int[]{x1, yF - 2, z1}, new int[]{x1, yF + 24, z - 24}, radius, 1.0, world);
                    }
                }
            }
        }
        return true;
    }
}

