/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.core.lang.I18n;

public class ButtonComponent
extends InteractivePopupComponent<Integer> {
    private final Minecraft minecraft;
    private final String buttonLabel;
    private final String[] buttonValues;
    private final ButtonElement button;
    private int value;

    public ButtonComponent(int width, String buttonLabel, String[] buttonValues, int defaultValue) {
        super(width);
        this.buttonLabel = buttonLabel;
        this.buttonValues = buttonValues;
        this.minecraft = Minecraft.getMinecraft();
        this.value = defaultValue;
        this.button = new ButtonElement(0, 0, 0, width, this.getHeight(), this.getButtonLabel());
    }

    private String getButtonLabel() {
        return I18n.getInstance().translateKeyAndFormat(this.buttonLabel, I18n.getInstance().translateKey(this.buttonValues[this.value]));
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        this.button.xPosition = x;
        this.button.yPosition = y;
        this.button.drawButton(this.minecraft, mouseX, mouseY);
    }

    @Override
    public void onClick(int x, int y, int button) {
        if (this.button.mouseClicked(this.minecraft, x, y)) {
            this.value = (this.value + 1) % this.buttonValues.length;
            this.button.displayString = this.getButtonLabel();
        }
    }

    @Override
    public Integer getOutput() {
        return this.value;
    }
}

