/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.linalg;

import net.minecraft.core.util.linalg.Matrix4;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class MatrixStack {
    @NotNull
    public static final MatrixStack MODEL_VIEW = new MatrixStack(5888, 2982);
    @NotNull
    public static final MatrixStack PROJECTION = new MatrixStack(5889, 2983);
    @NotNull
    public static final MatrixStack TEXTURE = new MatrixStack(5890, 2984);
    private final int matrixMode;
    private final int matrixMode2;
    private int depth = 0;

    private MatrixStack(int matrixMode, int matrixMode2) {
        this.matrixMode = matrixMode;
        this.matrixMode2 = matrixMode2;
    }

    @NotNull
    public Matrix4 peek() {
        GL11.glMatrixMode(this.matrixMode);
        double[] buffer = new double[16];
        GL11.glGetDoublev(this.matrixMode2, buffer);
        return Matrix4.fromPool(buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5], buffer[6], buffer[7], buffer[8], buffer[9], buffer[10], buffer[11], buffer[12], buffer[13], buffer[14], buffer[15]);
    }

    public void push() {
        GL11.glMatrixMode(this.matrixMode);
        GL11.glPushMatrix();
        ++this.depth;
    }

    public void pop() {
        GL11.glMatrixMode(this.matrixMode);
        if (this.depth == 0) {
            GL11.glLoadIdentity();
        } else {
            GL11.glPopMatrix();
        }
    }

    public void loadIdentity() {
        GL11.glMatrixMode(this.matrixMode);
        GL11.glLoadIdentity();
    }

    public void load(@NotNull Matrix4 matrix) {
        GL11.glMatrixMode(this.matrixMode);
        GL11.glLoadMatrixd(matrix.asArray());
    }
}

