/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicMatcher
extends BlockLogicAxisAligned {
    public final boolean isActive;

    public BlockLogicMatcher(Block<?> block, boolean isActive) {
        super(block, Material.stone);
        this.isActive = isActive;
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.updateState(world, x, y, z);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        Axis axis = mob.getPlacementDirection(side, PlacementMode.FACING).getAxis();
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicMatcher.axisToMeta(axis));
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        super.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    public void updateState(World world, int x, int y, int z) {
        Axis a = BlockLogicAxisAligned.metaToAxis(world.getBlockMetadata(x, y, z) & 3);
        int fx = x;
        int fy = y;
        int fz = z;
        int bx = x;
        int by = y;
        int bz = z;
        switch (a) {
            case X: {
                ++fx;
                --bx;
                break;
            }
            case Y: {
                ++fy;
                --by;
                break;
            }
            default: {
                ++fz;
                --bz;
            }
        }
        Block<?> fBlock = world.getBlock(fx, fy, fz);
        boolean backMatchesFront = fBlock == null ? world.getBlock(bx, by, bz) == null : fBlock.isEquivalent(world, fx, fy, fz, bx, by, bz);
        if (!this.isActive && backMatchesFront) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.MATCHER_ACTIVE.id(), world.getBlockMetadata(x, y, z));
        } else if (this.isActive && !backMatchesFront) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.MATCHER.id(), world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        Random random = world.rand;
        int redstoneBrightness = 10;
        double d = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)(y + 0) - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)(z + 0) - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)(x + 0) - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return this.isActive && BlockLogicAxisAligned.metaToAxis(worldSource.getBlockMetadata(x, y, z)) != side.getAxis();
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.IMPROPER_TOOL) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Blocks.MATCHER)};
    }
}

