/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.util.helper.Axis;
import org.jetbrains.annotations.NotNull;
import org.useless.util.GsonHelper;

public class Rotation {
    protected static final boolean DEFAULT_RESCALE = false;
    public final float originX;
    public final float originY;
    public final float originZ;
    public final Axis axis;
    public final float angle;
    public final boolean rescale;

    protected Rotation(float originX, float originY, float originZ, @NotNull Axis axis, float angle, boolean rescale) {
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
        this.axis = axis;
        this.angle = angle;
        this.rescale = rescale;
    }

    public String toString() {
        return "Rotation{originX=" + this.originX + ", originY=" + this.originY + ", originZ=" + this.originZ + ", axis=" + (Object)((Object)this.axis) + ", angle=" + this.angle + ", rescale=" + this.rescale + '}';
    }

    public static class Builder {
        protected final float originX;
        protected final float originY;
        protected final float originZ;
        @NotNull
        protected final Axis axis;
        protected final float angle;
        public boolean rescale = false;

        public Builder(float originX, float originY, float originZ, @NotNull Axis axis, float angle) {
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
            this.axis = Objects.requireNonNull(axis);
            this.angle = angle;
        }

        @NotNull
        public Builder setRescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        @NotNull
        protected Rotation build() {
            return new Rotation(this.originX, this.originY, this.originZ, this.axis, this.angle, this.rescale);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                float[] origin = GsonHelper.getAsFloatArray(object.get("origin"), 3);
                Builder builder = new Builder(origin[0], origin[1], origin[2], Axis.valueOf(object.get("axis").getAsString().toUpperCase(Locale.ROOT)), object.get("angle").getAsFloat());
                if (object.has("rescale")) {
                    builder.setRescale(object.get("rescale").getAsBoolean());
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

