/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.entity.MobRendererBipedArmored;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.BlocksContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererPlayer
extends MobRendererBipedArmored<Player> {
    private BlocksContainer container = null;

    public MobRendererPlayer() {
        super(0.5f);
    }

    @NotNull
    protected StaticEntityModel getActiveModel(@NotNull Player player, boolean onlyArms) {
        Specials specials = Specials.getSpecialsForPlayer(player);
        if (onlyArms) {
            if (specials != null && specials.armsModelReference != null) {
                return this.getModel(specials.armsModelReference);
            }
            return player.slimModel ? this.getModel("arms.slim") : this.getModel("arms");
        }
        if (specials != null) {
            return this.getModel(specials.mainModelReference);
        }
        return player.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }

    public void drawFirstPersonHand(@NotNull Tessellator tessellator, @NotNull Player player, boolean isLeft) {
        StaticEntityModel activeModel = this.getActiveModel(player, true);
        activeModel.resetBones();
        activeModel.getTransform((String)"leftSleeve").visible = player.playerConfig.sleeveLeftEnabled();
        activeModel.getTransform((String)"rightSleeve").visible = player.playerConfig.sleeveRightEnabled();
        if (isLeft) {
            activeModel.getTransform((String)"rightArm").visible = false;
        } else {
            activeModel.getTransform((String)"leftArm").visible = false;
        }
        activeModel.render(tessellator);
    }

    public void drawHeldObject(Player player, float partialTick) {
        if (player.getHeldObject() instanceof CarriedBlock) {
            CarriedBlock carriedBlock = (CarriedBlock)player.getHeldObject();
            if (this.container == null || this.container.world != player.world) {
                this.container = new BlocksContainer(player.world);
            }
            Tessellator tessellator = Tessellator.instance;
            Minecraft mc = Minecraft.getMinecraft();
            TextureRegistry.blockAtlas.bind();
            GL11.glPushMatrix();
            Lighting.disable();
            GL11.glBlendFunc(770, 771);
            GL11.glEnable(3042);
            GL11.glDisable(2884);
            if (mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel(7425);
            } else {
                GL11.glShadeModel(7424);
            }
            GL11.glScalef(0.55f, -0.55f, 0.55f);
            GL11.glTranslatef(0.0f, -0.75f, -0.75f);
            int blockX = MathHelper.floor(player.x);
            int blockY = MathHelper.floor(player.y) + 1;
            int blockZ = MathHelper.floor(player.z);
            tessellator.startDrawingQuads();
            tessellator.setTranslation((double)(-blockX) - 0.5, (double)(-blockY) - 0.5, (double)(-blockZ) - 0.5);
            this.container.setLightReferenceEntity(player);
            this.container.setBlock(blockX, blockY, blockZ, carriedBlock.blockId, carriedBlock.metadata, carriedBlock.entity);
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(carriedBlock.block())).renderNoCulling(Tessellator.instance, this.container, blockX, blockY, blockZ);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            this.container.setLightReferenceEntity(null);
            this.container.clear();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(carriedBlock.entity);
            if (renderer != null) {
                carriedBlock.entity.worldObj = player.world;
                renderer.doRender(tessellator, carriedBlock.entity, -0.5, -0.5, -0.5, partialTick);
                carriedBlock.entity.worldObj = null;
            }
            GL11.glPopMatrix();
            GL11.glEnable(2896);
            GL11.glEnable(16384);
            GL11.glEnable(16385);
            GL11.glEnable(2903);
        }
    }

    @Override
    protected void renderSpecials(@NotNull Tessellator t, @NotNull Player entity, double x, double y, double z) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() != Gamemode.spectator && entity.getGamemode() == Gamemode.spectator) {
            return;
        }
        if (Minecraft.getMinecraft().gameSettings.immersiveMode.drawNames() && this.renderDispatcher.camera != null) {
            float f3;
            if (this.renderDispatcher.camera instanceof EntityCamera && ((EntityCamera)this.renderDispatcher.camera).mob == entity) {
                return;
            }
            float f = 1.6f;
            float f1 = 0.026666671f;
            float f2 = (float)this.renderDispatcher.camera.distanceTo(entity);
            float f4 = f3 = entity.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entity.getDisplayName();
                if (!entity.isSneaking()) {
                    if (entity.isPlayerSleeping()) {
                        this.renderLivingLabel(t, entity, s, x, y - 1.5, z, 64, false);
                    } else {
                        this.renderLivingLabel(t, entity, s, x, y, z, 64, false);
                    }
                } else {
                    FontRenderer font = this.getFont();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)x + 0.0f, (float)y + 2.3f, (float)z);
                    GL11.glNormal3f(0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(-this.renderDispatcher.viewLerpYaw, 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(this.renderDispatcher.viewLerpPitch, 1.0f, 0.0f, 0.0f);
                    GL11.glScalef(-0.026666671f, -0.026666671f, 0.026666671f);
                    GL11.glDisable(2896);
                    GL11.glTranslatef(0.0f, 9.374998f, 0.0f);
                    GL11.glDepthMask(false);
                    GL11.glEnable(3042);
                    GL11.glBlendFunc(770, 771);
                    GL11.glDisable(3553);
                    t.startDrawingQuads();
                    int halfWidth = font.stringWidth(s) / 2;
                    t.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    t.addVertex(-halfWidth - 1, -1.0, 0.0);
                    t.addVertex(-halfWidth - 1, 8.0, 0.0);
                    t.addVertex(halfWidth + 1, 8.0, 0.0);
                    t.addVertex(halfWidth + 1, -1.0, 0.0);
                    t.draw();
                    GL11.glEnable(3553);
                    GL11.glDepthMask(true);
                    font.renderCentered(t, s, 0, 0).setColor(0x20FFFFFF).call();
                    GL11.glEnable(2896);
                    GL11.glDisable(3042);
                    GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @Override
    protected void preRenderTransform(@NotNull Player entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glTranslated(x, y, z);
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            GL11.glTranslatef(entity.sleepOffX, entity.sleepOffY, entity.sleepOffZ);
            GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
            GL11.glTranslatef(0.0f, -4.5f, 0.0f);
            GL11.glRotatef(-entity.getBedOrientationInDegrees(), 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.getMaxDeathRotation(entity), 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(270.0f, 0.0f, 1.0f, 0.0f);
        } else {
            GL11.glRotatef(-this.getBodyYaw(entity, partialTick) * MathHelper.RAD_TO_DEG, 0.0f, 1.0f, 0.0f);
            GL11.glScalef(0.0625f, 0.0625f, -0.0625f);
        }
        if (entity.deathTime > 0) {
            float rotationProgress = ((float)entity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GL11.glRotatef(rotationProgress * this.getMaxDeathRotation(entity), 0.0f, 0.0f, 1.0f);
        }
        float scale = 0.9375f;
        GL11.glScalef(0.9375f, 0.9375f, 0.9375f);
        if (entity.isDwarf()) {
            GL11.glScalef(0.6f, 0.5f, 0.6f);
        }
        if (Specials.getSpecialsForPlayer(entity) == Specials.MELON || Specials.getSpecialsForPlayer(entity) == Specials.WATERMELON) {
            GL11.glScalef(0.9f, 0.9f, 0.9f);
        }
    }

    @Override
    protected void renderAdditional(@NotNull Tessellator tessellator, @NotNull Player player, float partialTick) {
        StaticEntityModel activeModel = this.getActiveModel(player, false);
        super.renderAdditional(tessellator, player, partialTick);
        if (player.playerConfig.capeEnabled()) {
            boolean renderCape = this.bindDownloadableTexture("https://api.betterthanadventure.net/capes?username=" + player.username, null, null);
            if (!renderCape) {
                renderCape = this.bindDownloadableTexture(player.capeURL, null, null);
            }
            if (renderCape) {
                GL11.glPushMatrix();
                float brightness = Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled() ? 1.0f : player.getBrightness(partialTick);
                GL11.glColor4f(brightness, brightness, brightness, 1.0f);
                GL11.glTranslatef(0.0f, 0.0f, 0.125f);
                float yawOff = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialTick;
                float bodyAngle = 5.0f;
                double xd = MathHelper.lerp(player.xdO, player.xd, (double)partialTick);
                double yd = Math.min(MathHelper.lerp(player.ydO, player.yd, (double)partialTick), 0.0);
                double zd = MathHelper.lerp(player.zdO, player.zd, (double)partialTick);
                double vel = -1.0 / (3.0 * Math.hypot(xd, zd) + 1.0) + 1.0;
                double moveAng = Math.atan2(xd, zd);
                double yawRad = Math.toRadians(yawOff);
                double multiplier = 1.0 - Math.abs((Math.cos(yawRad) + 1.0 - (Math.cos(moveAng) + 1.0) + 2.0) / 2.0 - 1.0);
                player.wobbleTimer += (float)((double)((float)player.tickCount + partialTick - (float)player.lastRenderTick) / (30.0 - 29.0 * MathHelper.clamp(vel, 0.0, 1.0)));
                player.lastRenderTick = player.tickCount;
                double wobble = Math.sin(player.wobbleTimer) * (1.5 + 4.5 * vel * multiplier);
                activeModel.translateToBone("cape");
                StaticEntityModel cape = this.getModel("cape");
                cape.getTransform((String)"cape").rotX = -MathHelper.clamp(MathHelper.clamp(5.0 + vel * 100.0 * multiplier, 5.0, 100.0) + wobble - yd * 60.0, 0.0, 180.0) * (double)MathHelper.DEG_TO_RAD;
                cape.render(tessellator);
                GL11.glPopMatrix();
            }
        }
        if (player.getHeldObject() != null) {
            float walkSpeed = player.walkAnimSpeedO + (player.walkAnimSpeed - player.walkAnimSpeedO) * partialTick;
            float walkProgress = player.walkAnimPos - player.walkAnimSpeed * (1.0f - partialTick);
            float swingProgress = player.getSwingProgress(partialTick);
            float swing = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * -2.0f) * 0.4f;
            GL11.glTranslatef(0.0f, (MathHelper.cos(walkProgress / 2.0f * 2.0f / 3.0f + (float)Math.PI) / 12.0f * walkSpeed + 0.1f - swing / 4.0f) * 16.0f, 0.0f);
            GL11.glTranslatef(0.0f, 20.0f, 0.0f);
            if (player.isSneaking()) {
                GL11.glTranslatef(0.0f, 0.0f, 4.0f);
            }
            GL11.glScalef(-16.0f, -16.0f, 16.0f);
            this.drawHeldObject(player, partialTick);
        }
    }

    @Override
    @Nullable
    protected StaticEntityModel getActiveModel(@NotNull Player entity) {
        Specials specials = Specials.getSpecialsForPlayer(entity);
        if (specials != null) {
            return this.getModel(specials.mainModelReference);
        }
        return entity.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull Player entity, float brightness, float partialTick, int layer) {
        if (layer == 0) {
            return this.setupAnimations(entity, this.getActiveModel(entity, false), partialTick, layer);
        }
        return super.getAndSetupModelForLayer(entity, brightness, partialTick, layer);
    }

    @Override
    @Nullable
    protected StaticEntityModel setupAnimations(@NotNull Player entity, @Nullable StaticEntityModel model, float partialTick, int layer) {
        StaticEntityModel model1 = super.setupAnimations(entity, model, partialTick, layer);
        if (model1 != null && layer == 0) {
            model1.getTransform((String)"hat").visible = entity.playerConfig.hatEnabled();
            model1.getTransform((String)"jacket").visible = entity.playerConfig.jacketEnabled();
            model1.getTransform((String)"leftSleeve").visible = entity.playerConfig.sleeveLeftEnabled();
            model1.getTransform((String)"rightSleeve").visible = entity.playerConfig.sleeveRightEnabled();
            model1.getTransform((String)"leftPant").visible = entity.playerConfig.pantLeftEnabled();
            model1.getTransform((String)"rightPant").visible = entity.playerConfig.pantRightEnabled();
        }
        if (entity.isDwarf() && entity.isSneaking()) {
            BoneTransform waist = model.getTransform("waist");
            waist.posY -= 4.0;
        }
        return model1;
    }

    @Override
    public void loadEntityTexture(@NotNull Player entity) {
        this.bindDownloadableTexture(entity.skinURL, entity.getEntityTexture(), entity.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
    }

    public static enum Specials {
        SHIGN(UUID.fromString("49f6ea39-30b2-4441-b07c-7bfe0beeb61e"), "ShignBright", "main.shign", null),
        COOKIE(UUID.fromString("2c3bfa2c-95b0-48a8-baa2-9f3802190d86"), "DaCookieCakes", "main.cookie", null),
        THA_BOAR(UUID.fromString("f73086f5-d583-408b-a65c-d2dbdd9afaae"), "thaboar", "main.boar", null),
        MELON(UUID.fromString("9af822f9-ed7c-4afc-be28-2bd5b8c40b50"), "MelonMojito", "main.melon", "arms.melon"),
        WATERMELON(UUID.fromString("f9b18145-2be6-4817-8afb-a36e91369d2a"), "WatermelonMojito", "main.melon", "arms.melon");

        @NotNull
        public final UUID uuid;
        @NotNull
        public final String username;
        @NotNull
        public final String mainModelReference;
        @Nullable
        public final String armsModelReference;

        private Specials(@NotNull UUID uuid, @Nullable String username, String mainModelReference, String armsModelReference) {
            this.uuid = uuid;
            this.username = username;
            this.mainModelReference = mainModelReference;
            this.armsModelReference = armsModelReference;
        }

        @Nullable
        public static Specials getSpecialsForPlayer(@NotNull Player player) {
            if (!((Boolean)Minecraft.getMinecraft().gameSettings.devModels.value).booleanValue()) {
                return null;
            }
            if (player.uuid.equals(Specials.SHIGN.uuid) || player.username.equals(Specials.SHIGN.username)) {
                return SHIGN;
            }
            if (player.uuid.equals(Specials.COOKIE.uuid) || player.username.equals(Specials.COOKIE.username)) {
                return COOKIE;
            }
            if (player.uuid.equals(Specials.THA_BOAR.uuid) || player.username.equals(Specials.THA_BOAR.username)) {
                return THA_BOAR;
            }
            if (player.uuid.equals(Specials.MELON.uuid) || player.username.equals(Specials.MELON.username)) {
                return MELON;
            }
            if (player.uuid.equals(Specials.WATERMELON.uuid) || player.username.equals(Specials.WATERMELON.username)) {
                return WATERMELON;
            }
            return null;
        }

        @Nullable
        public static Specials getSpecialsForMob(@NotNull Mob mob) {
            if (!((Boolean)Minecraft.getMinecraft().gameSettings.devModels.value).booleanValue()) {
                return null;
            }
            if (mob.nickname.equals(Specials.SHIGN.username)) {
                return SHIGN;
            }
            if (mob.nickname.equals(Specials.COOKIE.username)) {
                return COOKIE;
            }
            if (mob.nickname.equals(Specials.THA_BOAR.username)) {
                return THA_BOAR;
            }
            if (mob.nickname.equals(Specials.MELON.username)) {
                return MELON;
            }
            if (mob.nickname.equals(Specials.WATERMELON.username)) {
                return WATERMELON;
            }
            return null;
        }
    }
}

