/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.block.mojang;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.mojang.BlockModelMojangData;
import org.useless.dragonfly.data.block.mojang.Element;
import org.useless.dragonfly.data.block.mojang.Face;

public class CompiledBlockModelMojangData {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public final BlockModelMojangData data;
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull IconCoordinate> textures = new HashMap<String, IconCoordinate>();
    @NotNull
    public final @NotNull C_Element @NotNull [] elements;
    public final int @NotNull [] particleIndices;
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull DisplayPos> displayPosMap;
    public final int renderLayer;

    public CompiledBlockModelMojangData(BlockModelMojangData data) {
        this.data = data;
        if (this.data.textures == null) {
            LOGGER.error("Model '{}' does not have assigned texture data!", (Object)data.modelId());
        } else {
            for (String key : data.textures.keySet()) {
                IconCoordinate coordinate = this.getTexture("#" + key, null, true);
                if (coordinate == null) continue;
                this.textures.put("#" + key, coordinate);
            }
        }
        IconCoordinate particleAll = this.textures.get("#particle");
        if (particleAll != null) {
            this.textures.putIfAbsent("#particle_up", particleAll);
            this.textures.putIfAbsent("#particle_down", particleAll);
            this.textures.putIfAbsent("#particle_north", particleAll);
            this.textures.putIfAbsent("#particle_south", particleAll);
            this.textures.putIfAbsent("#particle_west", particleAll);
            this.textures.putIfAbsent("#particle_east", particleAll);
            this.textures.putIfAbsent("#overlay", particleAll);
        } else {
            if (this.textures.get("#particle_up") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_up' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_down") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_down' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_north") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_north' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_south") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_south' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_west") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_west' symbol!", (Object)data.modelId());
            }
            if (this.textures.get("#particle_east") == null) {
                LOGGER.warn("Model '{}' does not have an assigned '#particle_east' symbol!", (Object)data.modelId());
            }
        }
        if (this.textures.get("#overlay") == null) {
            LOGGER.warn("Model '{}' does not have an assigned '#overlay' symbol!", (Object)data.modelId());
        }
        this.displayPosMap = new HashMap<String, DisplayPos>();
        if (data.displayPositions != null) {
            this.displayPosMap.putAll(data.displayPositions);
        }
        this.particleIndices = new int[6];
        if (data.particleIndices != null) {
            this.particleIndices[Direction.UP.getId()] = data.particleIndices.getOrDefault((Object)Direction.UP, 0);
            this.particleIndices[Direction.DOWN.getId()] = data.particleIndices.getOrDefault((Object)Direction.DOWN, 0);
            this.particleIndices[Direction.NORTH.getId()] = data.particleIndices.getOrDefault((Object)Direction.NORTH, 0);
            this.particleIndices[Direction.SOUTH.getId()] = data.particleIndices.getOrDefault((Object)Direction.SOUTH, 0);
            this.particleIndices[Direction.WEST.getId()] = data.particleIndices.getOrDefault((Object)Direction.WEST, 0);
            this.particleIndices[Direction.EAST.getId()] = data.particleIndices.getOrDefault((Object)Direction.EAST, 0);
        }
        this.renderLayer = data.renderLayer == null ? 0 : data.renderLayer;
        this.elements = new C_Element[data.elements == null ? 0 : data.elements.size()];
        if (data.elements != null) {
            int i = 0;
            for (Element e : data.elements) {
                this.elements[i++] = new C_Element(e);
            }
        }
    }

    protected IconCoordinate getTexture(@NotNull String textureSymbol, @Nullable IconCoordinate defaultCoordinate, boolean logWarnings) {
        try {
            if (this.data.textures == null) {
                if (logWarnings) {
                    LOGGER.warn("Model '{}' does not have assigned texture data!", (Object)this.data.modelId());
                }
                return defaultCoordinate;
            }
            @Nullable String path = this.data.textures.get(textureSymbol.startsWith("#") ? textureSymbol.substring(1) : textureSymbol);
            if (path == null) {
                if (logWarnings) {
                    LOGGER.warn("Texture for symbol '{}' is not assigned to any value!", (Object)textureSymbol);
                }
                return defaultCoordinate;
            }
            if (path.startsWith("#")) {
                return this.getTexture(path.substring(1), defaultCoordinate, logWarnings);
            }
            if (!path.contains(":")) {
                path = "minecraft:" + path;
            }
            if (TextureRegistry.hasTexture(path)) {
                return TextureRegistry.getTexture(path);
            }
            if (logWarnings) {
                LOGGER.warn("Texture for id '{}' does not exist!", (Object)path);
            }
            return BlockModelStandard.BLOCK_TEXTURE_MISSING;
        }
        catch (StackOverflowError stackOverflowError) {
            LOGGER.error("Recursive texture lookup from symbol '{}' in model '{}'!", (Object)textureSymbol, (Object)this.data.modelId());
            return defaultCoordinate;
        }
    }

    public static class C_Element {
        public static final int VERTEX_TOP_LEFT = 0;
        public static final int VERTEX_TOP_RIGHT = 3;
        public static final int VERTEX_BOTTOM_RIGHT = 2;
        public static final int VERTEX_BOTTOM_LEFT = 1;
        public static final int VERTEX_FLOAT_X = 0;
        public static final int VERTEX_FLOAT_Y = 1;
        public static final int VERTEX_FLOAT_Z = 2;
        public static final int VERTEX_FLOAT_U = 3;
        public static final int VERTEX_FLOAT_V = 4;
        public static final int FLOATS_PER_VERTEX = 5;
        public static final int NORMAL_FLOAT_X = 0;
        public static final int NORMAL_FLOAT_Y = 1;
        public static final int NORMAL_FLOAT_Z = 2;
        public static final int FLOATS_PER_NORMAL = 3;
        public final int lightEmission;
        public final boolean shade;
        public final float minX;
        public final float minY;
        public final float minZ;
        public final float maxX;
        public final float maxY;
        public final float maxZ;
        public final int faces;
        public final float @NotNull [] vertexData;
        public final float @NotNull [] normalData;
        public final int @NotNull [] tintIndices;
        public final @Nullable Direction @NotNull [] cullfaces;
        @NotNull
        public final @NotNull Direction @NotNull [] directions;
        @NotNull
        public final @NotNull String @NotNull [] textures;

        public C_Element(Element element) {
            this.faces = element.faces.size();
            this.vertexData = new float[this.faces * 4 * 5];
            this.normalData = new float[this.faces * 3];
            this.tintIndices = new int[this.faces];
            this.cullfaces = new Direction[this.faces];
            this.directions = new Direction[this.faces];
            this.textures = new String[this.faces];
            this.shade = element.shade;
            this.lightEmission = element.lightEmission;
            if (element.rotation != null && element.rotation.rescale) {
                float x = (45.0f - Math.abs((element.rotation.angle + 360.0f) % 360.0f - 45.0f)) / 45.0f;
                float scalar = MathHelper.sqrt_float(1.0f + x * x);
                float cx = element.rotation.originX * 0.0625f;
                float cy = element.rotation.originY * 0.0625f;
                float cz = element.rotation.originZ * 0.0625f;
                switch (element.rotation.axis) {
                    case X: {
                        this.minX = element.fromX * 0.0625f;
                        this.minY = (element.fromY * 0.0625f - cy) * scalar + cy;
                        this.minZ = (element.fromZ * 0.0625f - cz) * scalar + cz;
                        this.maxX = element.toX * 0.0625f;
                        this.maxY = (element.toY * 0.0625f - cy) * scalar + cy;
                        this.maxZ = (element.toZ * 0.0625f - cz) * scalar + cz;
                        break;
                    }
                    case Y: {
                        this.minY = element.fromY * 0.0625f;
                        this.minX = (element.fromX * 0.0625f - cx) * scalar + cx;
                        this.minZ = (element.fromZ * 0.0625f - cz) * scalar + cz;
                        this.maxY = element.toY * 0.0625f;
                        this.maxX = (element.toX * 0.0625f - cx) * scalar + cx;
                        this.maxZ = (element.toZ * 0.0625f - cz) * scalar + cz;
                        break;
                    }
                    default: {
                        this.minZ = element.fromZ * 0.0625f;
                        this.minX = (element.fromX * 0.0625f - cx) * scalar + cx;
                        this.minY = (element.fromY * 0.0625f - cy) * scalar + cy;
                        this.maxZ = element.toZ * 0.0625f;
                        this.maxX = (element.toX * 0.0625f - cx) * scalar + cx;
                        this.maxY = (element.toY * 0.0625f - cy) * scalar + cy;
                        break;
                    }
                }
            } else {
                this.minX = element.fromX * 0.0625f;
                this.minY = element.fromY * 0.0625f;
                this.minZ = element.fromZ * 0.0625f;
                this.maxX = element.toX * 0.0625f;
                this.maxY = element.toY * 0.0625f;
                this.maxZ = element.toZ * 0.0625f;
            }
            int i = 0;
            for (Map.Entry<Direction, Face> e : element.faces.entrySet()) {
                Direction d = e.getKey();
                Face f = e.getValue();
                float minU = f.u1 * 0.0625f;
                float maxU = f.u2 * 0.0625f;
                float minV = f.v1 * 0.0625f;
                float maxV = f.v2 * 0.0625f;
                this.tintIndices[i] = f.tintIndex;
                this.cullfaces[i] = f.cullFace;
                this.directions[i] = d;
                this.textures[i] = f.texture;
                int offset = i * 4 * 5;
                int rot = 4 - f.rotation;
                switch (d) {
                    case UP: {
                        this.vertexData[offset + 0 + 0] = this.maxX;
                        this.vertexData[offset + 0 + 1] = this.maxY;
                        this.vertexData[offset + 0 + 2] = this.maxZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 15 + 0] = this.minX;
                        this.vertexData[offset + 15 + 1] = this.maxY;
                        this.vertexData[offset + 15 + 2] = this.maxZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 10 + 0] = this.minX;
                        this.vertexData[offset + 10 + 1] = this.maxY;
                        this.vertexData[offset + 10 + 2] = this.minZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 5 + 0] = this.maxX;
                        this.vertexData[offset + 5 + 1] = this.maxY;
                        this.vertexData[offset + 5 + 2] = this.minZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = minV;
                        break;
                    }
                    case DOWN: {
                        this.vertexData[offset + 0 + 0] = this.minX;
                        this.vertexData[offset + 0 + 1] = this.minY;
                        this.vertexData[offset + 0 + 2] = this.maxZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 15 + 0] = this.maxX;
                        this.vertexData[offset + 15 + 1] = this.minY;
                        this.vertexData[offset + 15 + 2] = this.maxZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 10 + 0] = this.maxX;
                        this.vertexData[offset + 10 + 1] = this.minY;
                        this.vertexData[offset + 10 + 2] = this.minZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 5 + 0] = this.minX;
                        this.vertexData[offset + 5 + 1] = this.minY;
                        this.vertexData[offset + 5 + 2] = this.minZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = maxV;
                        break;
                    }
                    case NORTH: {
                        this.vertexData[offset + 0 + 0] = this.minX;
                        this.vertexData[offset + 0 + 1] = this.maxY;
                        this.vertexData[offset + 0 + 2] = this.minZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 15 + 0] = this.minX;
                        this.vertexData[offset + 15 + 1] = this.minY;
                        this.vertexData[offset + 15 + 2] = this.minZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 10 + 0] = this.maxX;
                        this.vertexData[offset + 10 + 1] = this.minY;
                        this.vertexData[offset + 10 + 2] = this.minZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 5 + 0] = this.maxX;
                        this.vertexData[offset + 5 + 1] = this.maxY;
                        this.vertexData[offset + 5 + 2] = this.minZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = minV;
                        break;
                    }
                    case SOUTH: {
                        this.vertexData[offset + 0 + 0] = this.minX;
                        this.vertexData[offset + 0 + 1] = this.maxY;
                        this.vertexData[offset + 0 + 2] = this.maxZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 15 + 0] = this.maxX;
                        this.vertexData[offset + 15 + 1] = this.maxY;
                        this.vertexData[offset + 15 + 2] = this.maxZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 10 + 0] = this.maxX;
                        this.vertexData[offset + 10 + 1] = this.minY;
                        this.vertexData[offset + 10 + 2] = this.maxZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 5 + 0] = this.minX;
                        this.vertexData[offset + 5 + 1] = this.minY;
                        this.vertexData[offset + 5 + 2] = this.maxZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = maxV;
                        break;
                    }
                    case WEST: {
                        this.vertexData[offset + 0 + 0] = this.minX;
                        this.vertexData[offset + 0 + 1] = this.maxY;
                        this.vertexData[offset + 0 + 2] = this.maxZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 15 + 0] = this.minX;
                        this.vertexData[offset + 15 + 1] = this.minY;
                        this.vertexData[offset + 15 + 2] = this.maxZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 10 + 0] = this.minX;
                        this.vertexData[offset + 10 + 1] = this.minY;
                        this.vertexData[offset + 10 + 2] = this.minZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 5 + 0] = this.minX;
                        this.vertexData[offset + 5 + 1] = this.maxY;
                        this.vertexData[offset + 5 + 2] = this.minZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = minV;
                        break;
                    }
                    case EAST: {
                        this.vertexData[offset + 0 + 0] = this.maxX;
                        this.vertexData[offset + 0 + 1] = this.minY;
                        this.vertexData[offset + 0 + 2] = this.maxZ;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (0 + rot) % 4 * 5 + 4] = maxV;
                        this.vertexData[offset + 15 + 0] = this.maxX;
                        this.vertexData[offset + 15 + 1] = this.maxY;
                        this.vertexData[offset + 15 + 2] = this.maxZ;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 3] = minU;
                        this.vertexData[offset + (3 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 10 + 0] = this.maxX;
                        this.vertexData[offset + 10 + 1] = this.maxY;
                        this.vertexData[offset + 10 + 2] = this.minZ;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (2 + rot) % 4 * 5 + 4] = minV;
                        this.vertexData[offset + 5 + 0] = this.maxX;
                        this.vertexData[offset + 5 + 1] = this.minY;
                        this.vertexData[offset + 5 + 2] = this.minZ;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 3] = maxU;
                        this.vertexData[offset + (1 + rot) % 4 * 5 + 4] = maxV;
                    }
                }
                ++i;
            }
            if (element.rotation != null) {
                for (int f = 0; f < this.faces; ++f) {
                    for (int v = 0; v < 4; ++v) {
                        float nz;
                        float ny;
                        float nx;
                        int offset = f * 4 * 5 + v * 5;
                        float x = this.vertexData[offset + 0] - element.rotation.originX * 0.0625f;
                        float y = this.vertexData[offset + 1] - element.rotation.originY * 0.0625f;
                        float z = this.vertexData[offset + 2] - element.rotation.originZ * 0.0625f;
                        float sin = MathHelper.sin(MathHelper.toRadians(element.rotation.angle));
                        float cos = MathHelper.cos(MathHelper.toRadians(element.rotation.angle));
                        switch (element.rotation.axis) {
                            case X: {
                                nx = x;
                                ny = y * cos - z * sin;
                                nz = z * cos + y * sin;
                                break;
                            }
                            case Y: {
                                nx = x * cos - z * sin;
                                ny = y;
                                nz = z * cos + x * sin;
                                break;
                            }
                            default: {
                                nx = x * cos - y * sin;
                                ny = y * cos + x * sin;
                                nz = z;
                            }
                        }
                        this.vertexData[offset + 0] = nx + element.rotation.originX * 0.0625f;
                        this.vertexData[offset + 1] = ny + element.rotation.originY * 0.0625f;
                        this.vertexData[offset + 2] = nz + element.rotation.originZ * 0.0625f;
                    }
                }
            }
            for (int f = 0; f < this.faces; ++f) {
                int offset = f * 4 * 5;
                float ax = this.vertexData[offset + 10 + 0] - this.vertexData[offset + 5 + 0];
                float ay = this.vertexData[offset + 10 + 1] - this.vertexData[offset + 5 + 1];
                float az = this.vertexData[offset + 10 + 2] - this.vertexData[offset + 5 + 2];
                float bx = this.vertexData[offset + 15 + 0] - this.vertexData[offset + 5 + 0];
                float by = this.vertexData[offset + 15 + 1] - this.vertexData[offset + 5 + 1];
                float bz = this.vertexData[offset + 15 + 2] - this.vertexData[offset + 5 + 2];
                float nx = ay * bz - az * by;
                float ny = az * bx - ax * bz;
                float nz = ax * by - ay * bx;
                float length = MathHelper.sqrt_float(nx * nx + ny * ny + nz * nz);
                this.normalData[f * 3 + 0] = nx /= length;
                this.normalData[f * 3 + 1] = ny /= length;
                this.normalData[f * 3 + 2] = nz /= length;
            }
        }
    }
}

