/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor.components;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.Tag;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.AbstractTagComponent;
import net.minecraft.client.gui.popup.PopupBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class ArrayTagComponent<T>
extends AbstractTagComponent<T> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ArrayTagComponent(@NotNull Screen attachedScreen, @NotNull Tag<T> tag) {
        super(attachedScreen, tag);
    }

    @Override
    public void onMouseClick(int mx, int my, int mouseButton, float partialTick) {
        if (this.isHovered(mx, my, partialTick) && mouseButton == 0) {
            this.attachedScreen.mc.displayScreen(new PopupBuilder(this.attachedScreen, 400).withTextField("input", this.valueToString()).closeOnEsc(0).closeOnEnter(0).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 0) {
                    try {
                        this.parseValueFromString((String)results.get("input"));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse input '{}' into a '{}'!", results.get("input"), this.tag.getClass().getSimpleName(), e);
                    }
                }
            }).build());
        }
    }

    @NotNull
    public abstract String valueToString();

    public abstract void parseValueFromString(@NotNull String var1) throws Exception;
}

