/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProviderNether;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeFXNether
extends WorldTypeFX {
    public WorldTypeFXNether(WorldType worldType) {
        super(worldType);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor(x);
            int y1 = MathHelper.floor(y);
            int z1 = MathHelper.floor(z);
            int color = Colorizers.fog.getColor(world, x1, y1, z1);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return Vec3.fromPool(r, g, b);
        }
        float r = 0.23529412f;
        float g = 0.0f;
        float b = 0.0f;
        double temp = ((BiomeProviderNether)world.getBiomeProvider()).getTemperature(x, z);
        if (temp < 0.25) {
            r = 0.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (temp < 0.5) {
            double toLerp = temp - 0.25;
            r = MathHelper.lerp(0.0f, r, (float)(toLerp *= 4.0));
            g = MathHelper.lerp(0.0f, g, (float)toLerp);
            b = MathHelper.lerp(0.0f, b, (float)toLerp);
        }
        return Vec3.fromPool(r, g, b);
    }

    @Override
    public void playerAnimationTick(World world, Player player) {
        int radius = 12;
        double x = player.x;
        double y = player.y;
        double z = player.z;
        Biome localBiome = world.getBlockBiome((int)x, (int)y, (int)z);
        if (localBiome == Biomes.NETHER_ASH_PLAINS || localBiome == Biomes.NETHER_BONEYARD) {
            for (int i = 0; i < 5; ++i) {
                double rz;
                double ry;
                double rx = x - 12.0 + world.rand.nextDouble() * 12.0 * 2.0;
                if (world.getBlockId((int)rx, (int)(ry = y - 12.0 + world.rand.nextDouble() * 12.0 * 2.0), (int)(rz = z - 12.0 + world.rand.nextDouble() * 12.0 * 2.0)) != 0) continue;
                world.spawnParticle("ashmote", rx, ry, rz, 0.0, 0.0, 0.0, 0);
            }
        }
    }
}

