/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityPrimedTNT;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobGiant;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileArrowGolden;
import net.minecraft.core.entity.projectile.ProjectileArrowPurple;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.entity.projectile.ProjectileEgg;
import net.minecraft.core.entity.projectile.ProjectileFireball;
import net.minecraft.core.entity.projectile.ProjectilePebble;
import net.minecraft.core.entity.projectile.ProjectileSnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class EntityDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int mappingCount = 0;
    public static final Map<Class<? extends Entity>, NamespaceID> classToIdMap = new HashMap<Class<? extends Entity>, NamespaceID>();
    public static final Map<NamespaceID, Class<? extends Entity>> idToClassMap = new HashMap<NamespaceID, Class<? extends Entity>>();
    public static final Map<String, Class<? extends Entity>> stringIdToClassMap = new HashMap<String, Class<? extends Entity>>();
    private static final Int2ObjectMap<Class<? extends Entity>> numericIdToClassMap = new Int2ObjectOpenHashMap<Class<? extends Entity>>();
    private static final Int2ObjectMap<String> numericIdToStringIdMap = new Int2ObjectOpenHashMap<String>();
    private static final Object2IntMap<Class<? extends Entity>> classToNumericIdMap = new Object2IntOpenHashMap<Class<? extends Entity>>();
    private static final Map<Class<? extends Entity>, String> classToNameKeyMap = new HashMap<Class<? extends Entity>, String>();
    private static boolean hasInit = false;

    private EntityDispatcher() {
    }

    public static void addMapping(@NotNull Class<? extends Entity> entityClass, @NotNull NamespaceID namespaceID) {
        EntityDispatcher.addMapping(entityClass, namespaceID, null);
    }

    public static void addMapping(@NotNull Class<? extends Entity> entityClass, @NotNull NamespaceID namespaceID, @Nullable String nameKey) {
        if (classToIdMap.containsKey(entityClass)) {
            throw new IllegalArgumentException("EntityDispatcher already contains an assignment for class " + entityClass.getSimpleName() + " with namespace " + classToIdMap.get(entityClass) + "!");
        }
        @NotNull NamespaceID unpooledNamespaceID = (NamespaceID)namespaceID.copyUnpooled();
        classToIdMap.put(entityClass, unpooledNamespaceID);
        idToClassMap.put(unpooledNamespaceID, entityClass);
        stringIdToClassMap.put(unpooledNamespaceID.toString(), entityClass);
        int numericId = mappingCount++;
        numericIdToClassMap.put(numericId, entityClass);
        numericIdToStringIdMap.put(numericId, unpooledNamespaceID.toString());
        classToNumericIdMap.put(entityClass, numericId);
        if (nameKey != null) {
            classToNameKeyMap.put(entityClass, nameKey);
        }
    }

    @Nullable
    public static Class<? extends Entity> classForId(@NotNull NamespaceID id) {
        return idToClassMap.get(id);
    }

    @Nullable
    public static Class<? extends Entity> classForId(@NotNull String id) {
        return stringIdToClassMap.get(id);
    }

    @Nullable
    public static NamespaceID idForClass(Class<? extends Entity> entityClass) {
        return classToIdMap.get(entityClass);
    }

    @Nullable
    public static Class<? extends Entity> classForNumericId(int id) {
        return (Class)numericIdToClassMap.get(id);
    }

    @Nullable
    public static String nameKeyForClass(Class<? extends Entity> entityClass) {
        return classToNameKeyMap.get(entityClass);
    }

    public static int numericIdForClass(Class<? extends Entity> entityClass) {
        return classToNumericIdMap.getOrDefault((Object)entityClass, -1);
    }

    public static void setNumericIds(@NotNull Int2ObjectMap<String> mapping) {
        numericIdToClassMap.clear();
        numericIdToStringIdMap.clear();
        classToNumericIdMap.clear();
        for (Int2ObjectMap.Entry entry : mapping.int2ObjectEntrySet()) {
            Class<? extends Entity> entityClass = EntityDispatcher.classForId((String)entry.getValue());
            if (entityClass == null) {
                LOGGER.error("Could not find entityClass assigned to namespace id {}! Skipping!", entry.getValue());
                continue;
            }
            numericIdToClassMap.put(entry.getIntKey(), entityClass);
            numericIdToStringIdMap.put(entry.getIntKey(), (String)entry.getValue());
            classToNumericIdMap.put(entityClass, entry.getIntKey());
            if (entry.getIntKey() < mappingCount) continue;
            mappingCount = entry.getIntKey() + 1;
        }
    }

    public static Int2ObjectMap<String> getEntityIds() {
        return numericIdToStringIdMap;
    }

    @Nullable
    public static Entity createEntityInWorld(@Nullable String id, @NotNull World world) {
        if (id == null) {
            return null;
        }
        if (Legacy.isLegacyKey(id)) {
            return EntityDispatcher.createEntityInWorld(Legacy.getClassFromEncodeID(id), world);
        }
        Class<? extends Entity> entityClass = EntityDispatcher.classForId(id);
        if (entityClass == null) {
            LOGGER.warn("EntityDispatcher could not find entity class for id '{}'!", (Object)id);
            return null;
        }
        return EntityDispatcher.createEntityInWorld(entityClass, world);
    }

    @Nullable
    public static Entity createEntityInWorld(@NotNull NamespaceID id, @NotNull World world) {
        return EntityDispatcher.createEntityInWorld(EntityDispatcher.classForId(id), world);
    }

    @Nullable
    public static Entity createEntityInWorld(@Nullable Class<? extends Entity> clazz, @NotNull World world) {
        Entity entity = null;
        try {
            if (clazz == null) {
                return null;
            }
            entity = clazz.getConstructor(World.class).newInstance(world);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to instance for class '{}'!", (Object)clazz.getSimpleName(), (Object)exception);
        }
        return entity;
    }

    public static Entity createEntityFromNBT(CompoundTag compoundTag, World world) {
        String id = compoundTag.getStringOrDefault("id", "UNKNOWN");
        Entity entity = EntityDispatcher.createEntityInWorld(id, world);
        if (entity != null) {
            entity.load(compoundTag);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)compoundTag.getStringOrDefault("id", "UNKNOWN"));
        }
        return entity;
    }

    @Nullable
    public static Entity createEntity(int id, World world) {
        @Nullable Entity entity = null;
        try {
            Class<? extends Entity> clazz = EntityDispatcher.classForNumericId(id);
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            } else {
                LOGGER.error("No entity class assign to id {}!", (Object)id);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to instance entity id '{}'!", (Object)id, (Object)exception);
        }
        return entity;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        EntityDispatcher.addMapping(EntityItem.class, NamespaceID.fromPool("minecraft", "item"));
        EntityDispatcher.addMapping(EntityPainting.class, NamespaceID.fromPool("minecraft", "painting"));
        EntityDispatcher.addMapping(EntityLightning.class, NamespaceID.fromPool("minecraft", "lightning"));
        EntityDispatcher.addMapping(EntityFallingBlock.class, NamespaceID.fromPool("minecraft", "falling_block"));
        EntityDispatcher.addMapping(EntityMinecart.class, NamespaceID.fromPool("minecraft", "minecart"));
        EntityDispatcher.addMapping(EntityBoat.class, NamespaceID.fromPool("minecraft", "boat"));
        EntityDispatcher.addMapping(EntityPrimedTNT.class, NamespaceID.fromPool("minecraft", "primed_tnt"));
        EntityDispatcher.addMapping(ProjectilePebble.class, NamespaceID.fromPool("minecraft", "pebble"));
        EntityDispatcher.addMapping(ProjectileEgg.class, NamespaceID.fromPool("minecraft", "egg"));
        EntityDispatcher.addMapping(ProjectileArrow.class, NamespaceID.fromPool("minecraft", "arrow"));
        EntityDispatcher.addMapping(ProjectileArrowGolden.class, NamespaceID.fromPool("minecraft", "arrow_golden"));
        EntityDispatcher.addMapping(ProjectileArrowPurple.class, NamespaceID.fromPool("minecraft", "arrow_purple"));
        EntityDispatcher.addMapping(ProjectileSnowball.class, NamespaceID.fromPool("minecraft", "snowball"));
        EntityDispatcher.addMapping(ProjectileFireball.class, NamespaceID.fromPool("minecraft", "fireball"));
        EntityDispatcher.addMapping(ProjectileCannonball.class, NamespaceID.fromPool("minecraft", "cannonball"));
        EntityDispatcher.addMapping(Mob.class, NamespaceID.fromPool("minecraft", "mob"));
        EntityDispatcher.addMapping(MobHuman.class, NamespaceID.fromPool("minecraft", "human"));
        EntityDispatcher.addMapping(Player.class, NamespaceID.fromPool("minecraft", "player"));
        EntityDispatcher.addMapping(MobZombie.class, NamespaceID.fromPool("minecraft", "zombie"), "guidebook.section.mob.zombie.name");
        EntityDispatcher.addMapping(MobZombieArmored.class, NamespaceID.fromPool("minecraft", "zombie_armored"), "guidebook.section.mob.armored_zombie.name");
        EntityDispatcher.addMapping(MobZombiePig.class, NamespaceID.fromPool("minecraft", "zombie_pigman"), "guidebook.section.mob.zombie_pigman.name");
        EntityDispatcher.addMapping(MobCreeper.class, NamespaceID.fromPool("minecraft", "creeper"), "guidebook.section.mob.creeper.name");
        EntityDispatcher.addMapping(MobSkeleton.class, NamespaceID.fromPool("minecraft", "skeleton"), "guidebook.section.mob.skeleton.name");
        EntityDispatcher.addMapping(MobSpider.class, NamespaceID.fromPool("minecraft", "spider"), "guidebook.section.mob.spider.name");
        EntityDispatcher.addMapping(MobGiant.class, NamespaceID.fromPool("minecraft", "giant"));
        EntityDispatcher.addMapping(MobSlime.class, NamespaceID.fromPool("minecraft", "slime"), "guidebook.section.mob.slime.name");
        EntityDispatcher.addMapping(MobGhast.class, NamespaceID.fromPool("minecraft", "ghast"), "guidebook.section.mob.ghast.name");
        EntityDispatcher.addMapping(MobSnowman.class, NamespaceID.fromPool("minecraft", "snowman"), "guidebook.section.mob.snowman.name");
        EntityDispatcher.addMapping(MobScorpion.class, NamespaceID.fromPool("minecraft", "scorpion"));
        EntityDispatcher.addMapping(MobPig.class, NamespaceID.fromPool("minecraft", "pig"), "guidebook.section.mob.pig.name");
        EntityDispatcher.addMapping(MobSheep.class, NamespaceID.fromPool("minecraft", "sheep"), "guidebook.section.mob.sheep.name");
        EntityDispatcher.addMapping(MobCow.class, NamespaceID.fromPool("minecraft", "cow"), "guidebook.section.mob.cow.name");
        EntityDispatcher.addMapping(MobChicken.class, NamespaceID.fromPool("minecraft", "chicken"), "guidebook.section.mob.chicken.name");
        EntityDispatcher.addMapping(MobSquid.class, NamespaceID.fromPool("minecraft", "squid"), "guidebook.section.mob.squid.name");
        EntityDispatcher.addMapping(MobWolf.class, NamespaceID.fromPool("minecraft", "wolf"), "guidebook.section.mob.wolf.name");
        EntityDispatcher.addMapping(MobFireflyCluster.class, NamespaceID.fromPool("minecraft", "firefly_cluster"), "guidebook.section.mob.firefly_cluster.name");
        EntityDispatcher.addMapping(MobButterfly.class, NamespaceID.fromPool("minecraft", "butterfly"), "guidebook.section.mob.butterfly.name");
        EntityDispatcher.addMapping(MobDeer.class, NamespaceID.fromPool("minecraft", "deer"), "guidebook.section.mob.deer.name");
    }

    @Deprecated
    public static class Legacy {
        public static final Map<String, Class<? extends Entity>> keyToClassMap = new HashMap<String, Class<? extends Entity>>();
        public static final Map<Class<? extends Entity>, String> classToKeyMap = new HashMap<Class<? extends Entity>, String>();
        private static final Int2ObjectMap<Class<? extends Entity>> idToClassMap = new Int2ObjectArrayMap<Class<? extends Entity>>();
        private static final Object2IntMap<Class<? extends Entity>> classToIdMap = new Object2IntArrayMap<Class<? extends Entity>>();
        private static int maxIdSize = 0;

        @Deprecated
        public static void addMapping(Class<? extends Entity> clazz, String key, int id) {
            keyToClassMap.put(key, clazz);
            classToKeyMap.put(clazz, key);
            idToClassMap.put(id, clazz);
            classToIdMap.put(clazz, id);
            if (key.length() > maxIdSize) {
                maxIdSize = key.length();
            }
        }

        @Deprecated
        public static int getEntityID(Entity entity) {
            return Legacy.getEntityID(entity.getClass());
        }

        @Deprecated
        public static int getEntityID(Class<? extends Entity> entityClass) {
            return classToIdMap.get(entityClass);
        }

        @Deprecated
        public static String getEncodeId(Entity entity) {
            return classToKeyMap.get(entity.getClass());
        }

        @Deprecated
        public static String getEncodeId(Class<? extends Entity> clazz) {
            return classToKeyMap.get(clazz);
        }

        @Deprecated
        public static Class<? extends Entity> getClassFromID(int id) {
            return (Class)idToClassMap.get(id);
        }

        @Deprecated
        public static Class<? extends Entity> getClassFromEncodeID(String encodeID) {
            return keyToClassMap.get(encodeID);
        }

        @Deprecated
        public static int getLargestIdSize() {
            return maxIdSize;
        }

        public static boolean isLegacyKey(String key) {
            return keyToClassMap.containsKey(key);
        }

        static {
            Legacy.addMapping(EntityItem.class, "Item", 1);
            Legacy.addMapping(EntityLightning.class, "Lightning", 8);
            Legacy.addMapping(EntityPainting.class, "Painting", 9);
            Legacy.addMapping(ProjectileArrow.class, "Arrow", 10);
            Legacy.addMapping(ProjectileSnowball.class, "Snowball", 11);
            Legacy.addMapping(ProjectileFireball.class, "Fireball", 12);
            Legacy.addMapping(EntityPrimedTNT.class, "PrimedTnt", 20);
            Legacy.addMapping(EntityFallingBlock.class, "FallingSand", 21);
            Legacy.addMapping(EntityMinecart.class, "Minecart", 40);
            Legacy.addMapping(EntityBoat.class, "Boat", 41);
            Legacy.addMapping(MobZombieArmored.class, "ArmouredZombie", 42);
            Legacy.addMapping(ProjectileArrowGolden.class, "ArrowGolden", 43);
            Legacy.addMapping(ProjectileCannonball.class, "Cannonball", 44);
            Legacy.addMapping(ProjectileArrowPurple.class, "ArrowPurple", 45);
            Legacy.addMapping(ProjectilePebble.class, "Pebble", 46);
            Legacy.addMapping(MobFireflyCluster.class, "FireflyCluster", 47);
            Legacy.addMapping(Mob.class, "Mob", 48);
            Legacy.addMapping(MobHuman.class, "MobMonster", 49);
            Legacy.addMapping(MobCreeper.class, "Creeper", 50);
            Legacy.addMapping(MobSkeleton.class, "Skeleton", 51);
            Legacy.addMapping(MobSpider.class, "Spider", 52);
            Legacy.addMapping(MobGiant.class, "Giant", 53);
            Legacy.addMapping(MobZombie.class, "Zombie", 54);
            Legacy.addMapping(MobSlime.class, "Slime", 55);
            Legacy.addMapping(MobGhast.class, "Ghast", 56);
            Legacy.addMapping(MobZombiePig.class, "PigZombie", 57);
            Legacy.addMapping(MobSnowman.class, "Snowman", 58);
            Legacy.addMapping(MobScorpion.class, "Scorpion", 59);
            Legacy.addMapping(MobPig.class, "Pig", 90);
            Legacy.addMapping(MobSheep.class, "Sheep", 91);
            Legacy.addMapping(MobCow.class, "Cow", 92);
            Legacy.addMapping(MobChicken.class, "Chicken", 93);
            Legacy.addMapping(MobSquid.class, "Squid", 94);
            Legacy.addMapping(MobWolf.class, "Wolf", 95);
        }
    }
}

