/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityBasket;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.block.entity.TileEntityJarButterfly;
import net.minecraft.core.block.entity.TileEntityJukebox;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityNoteblock;
import net.minecraft.core.block.entity.TileEntitySeat;
import net.minecraft.core.block.entity.TileEntitySensor;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TileEntityDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<NamespaceID, Class<? extends TileEntity>> idToClassMap = new HashMap<NamespaceID, Class<? extends TileEntity>>();
    private static final Map<String, Class<? extends TileEntity>> stringToClassMap = new HashMap<String, Class<? extends TileEntity>>();
    private static final Map<Class<? extends TileEntity>, NamespaceID> classToIdMap = new HashMap<Class<? extends TileEntity>, NamespaceID>();
    private static boolean hasInit = false;

    public static void addMapping(Class<? extends TileEntity> entityClass, NamespaceID id) {
        if (idToClassMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate id: " + id);
        }
        @NotNull NamespaceID unpooledId = (NamespaceID)id.copyUnpooled();
        idToClassMap.put(unpooledId, entityClass);
        stringToClassMap.put(unpooledId.toString(), entityClass);
        classToIdMap.put(entityClass, unpooledId);
    }

    public static TileEntity createAndLoadEntity(CompoundTag compoundTag) {
        TileEntity tileEntity = null;
        Class<? extends TileEntity> entityClass = TileEntityDispatcher.getClassFromID(compoundTag.getString("id"));
        try {
            if (entityClass != null) {
                tileEntity = entityClass.newInstance();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception when instancing class '{}'!", (Object)entityClass.getSimpleName(), (Object)exception);
        }
        if (tileEntity != null) {
            tileEntity.readFromNBT(compoundTag);
        } else {
            LOGGER.warn("Skipping TileEntity with id {}", (Object)compoundTag.getString("id"));
        }
        return tileEntity;
    }

    public static Class<? extends TileEntity> getClassFromID(String id) {
        if (Legacy.isLegacyKey(id)) {
            return Legacy.getClassFromID(id);
        }
        return stringToClassMap.get(id);
    }

    public static Class<? extends TileEntity> getClassFromID(NamespaceID id) {
        return idToClassMap.get(id);
    }

    public static NamespaceID getIDFromClass(Class<? extends TileEntity> clazz) {
        return classToIdMap.get(clazz);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        TileEntityDispatcher.addMapping(TileEntityFurnace.class, NamespaceID.fromPool("minecraft", "furnace"));
        TileEntityDispatcher.addMapping(TileEntityChest.class, NamespaceID.fromPool("minecraft", "chest"));
        TileEntityDispatcher.addMapping(TileEntityJukebox.class, NamespaceID.fromPool("minecraft", "jukebox"));
        TileEntityDispatcher.addMapping(TileEntityDispenser.class, NamespaceID.fromPool("minecraft", "dispenser"));
        TileEntityDispatcher.addMapping(TileEntityActivator.class, NamespaceID.fromPool("minecraft", "activator"));
        TileEntityDispatcher.addMapping(TileEntitySign.class, NamespaceID.fromPool("minecraft", "sign"));
        TileEntityDispatcher.addMapping(TileEntityMobSpawner.class, NamespaceID.fromPool("minecraft", "mob_spawner"));
        TileEntityDispatcher.addMapping(TileEntityMovingPistonBlock.class, NamespaceID.fromPool("minecraft", "piston_moving"));
        TileEntityDispatcher.addMapping(TileEntityFurnaceBlast.class, NamespaceID.fromPool("minecraft", "furnace_blast"));
        TileEntityDispatcher.addMapping(TileEntitySensor.class, NamespaceID.fromPool("minecraft", "sensor"));
        TileEntityDispatcher.addMapping(TileEntityTrommel.class, NamespaceID.fromPool("minecraft", "trommel"));
        TileEntityDispatcher.addMapping(TileEntityBasket.class, NamespaceID.fromPool("minecraft", "basket"));
        TileEntityDispatcher.addMapping(TileEntityFlag.class, NamespaceID.fromPool("minecraft", "flag"));
        TileEntityDispatcher.addMapping(TileEntitySeat.class, NamespaceID.fromPool("minecraft", "seat"));
        TileEntityDispatcher.addMapping(TileEntityFlowerJar.class, NamespaceID.fromPool("minecraft", "jar_flower"));
        TileEntityDispatcher.addMapping(TileEntityJarButterfly.class, NamespaceID.fromPool("minecraft", "jar_butterfly"));
        TileEntityDispatcher.addMapping(TileEntityMeshGold.class, NamespaceID.fromPool("minecraft", "mesh_gold"));
        TileEntityDispatcher.addMapping(TileEntityStatue.class, NamespaceID.fromPool("minecraft", "statue_stone"));
    }

    @Deprecated
    public static class Legacy {
        private static final Map<String, Class<? extends TileEntity>> nameToClassMap = new HashMap<String, Class<? extends TileEntity>>();
        private static final Map<Class<? extends TileEntity>, String> classToNameMap = new HashMap<Class<? extends TileEntity>, String>();

        @Deprecated
        public static Class<? extends TileEntity> getClassFromID(String id) {
            return nameToClassMap.get(id);
        }

        @Deprecated
        public static String getIDFromClass(Class<? extends TileEntity> clazz) {
            return classToNameMap.get(clazz);
        }

        @Deprecated
        public static void addMapping(Class<? extends TileEntity> entityClass, String name) {
            if (nameToClassMap.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate id: " + name);
            }
            nameToClassMap.put(name, entityClass);
            classToNameMap.put(entityClass, name);
        }

        public static boolean isLegacyKey(String id) {
            return nameToClassMap.containsKey(id);
        }

        static {
            Legacy.addMapping(TileEntityFurnace.class, "Furnace");
            Legacy.addMapping(TileEntityChest.class, "Chest");
            Legacy.addMapping(TileEntityJukebox.class, "RecordPlayer");
            Legacy.addMapping(TileEntityDispenser.class, "Trap");
            Legacy.addMapping(TileEntityActivator.class, "Activator");
            Legacy.addMapping(TileEntitySign.class, "Sign");
            Legacy.addMapping(TileEntityMobSpawner.class, "MobSpawner");
            Legacy.addMapping(TileEntityNoteblock.class, "Music");
            Legacy.addMapping(TileEntityMovingPistonBlock.class, "Piston");
            Legacy.addMapping(TileEntityFurnaceBlast.class, "BlastFurnace");
            Legacy.addMapping(TileEntitySensor.class, "Sensor");
            Legacy.addMapping(TileEntityTrommel.class, "Trommel");
            Legacy.addMapping(TileEntityBasket.class, "Basket");
            Legacy.addMapping(TileEntityFlag.class, "Flag");
            Legacy.addMapping(TileEntitySeat.class, "Seat");
            Legacy.addMapping(TileEntityFlowerJar.class, "FlowerJar");
            Legacy.addMapping(TileEntityMeshGold.class, "MeshGold");
        }
    }
}

