/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ShortTag
extends Tag<Short> {
    public ShortTag() {
        this(0);
    }

    public ShortTag(short value) {
        super(value);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeShort(((Short)this.getValue()).shortValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.setValue(dis.readShort());
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_SHORT.getId();
    }

    @Override
    public void fromJson(@NotNull JsonElement json) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Json element '" + json + "' is not a valid shortTag!");
        }
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (!primitive.isNumber()) {
            throw new JsonParseException("Json element '" + json + "' is not a number!");
        }
        this.setValue(primitive.getAsShort());
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": " + this.getValue();
    }
}

