/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.mobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public abstract class MobInfoRegistry {
    private static final Map<Class<? extends Entity>, MobInfo> mobInfoMap = new HashMap<Class<? extends Entity>, MobInfo>();
    private static final List<Class<? extends Entity>> mobClassList = new ArrayList<Class<? extends Entity>>();

    public static void register(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
        mobClassList.add(entityClass);
        mobInfoMap.put(entityClass, new MobInfo(entityClass, nameTranslationKey, descriptionTranslationKey, health, score, drops));
    }

    public static List<Class<? extends Entity>> getMobClassList() {
        return Collections.unmodifiableList(mobClassList);
    }

    public static MobInfo getMobInfo(Class<? extends Entity> entityClass) {
        return mobInfoMap.get(entityClass);
    }

    static {
        MobInfoRegistry.register(MobPig.class, "guidebook.section.mob.pig.name", "guidebook.section.mob.pig.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.FOOD_PORKCHOP_RAW), 1.0f, 1, 2)});
        MobInfoRegistry.register(MobSheep.class, "guidebook.section.mob.sheep.name", "guidebook.section.mob.sheep.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Blocks.WOOL), 1.0f, 1, 1)});
        MobInfoRegistry.register(MobCow.class, "guidebook.section.mob.cow.name", "guidebook.section.mob.cow.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.LEATHER), 1.0f, 1, 5)});
        MobInfoRegistry.register(MobChicken.class, "guidebook.section.mob.chicken.name", "guidebook.section.mob.chicken.desc", 4, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.FEATHER_CHICKEN), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobDeer.class, "guidebook.section.mob.deer.name", "guidebook.section.mob.deer.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.FOOD_VENISON_RAW), 1.0f, 1, 2)});
        MobInfoRegistry.register(MobSquid.class, "guidebook.section.mob.squid.name", "guidebook.section.mob.squid.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Items.DYE, 1, 0), 1.0f, 1, 3)});
        MobInfoRegistry.register(MobWolf.class, "guidebook.section.mob.wolf.name", "guidebook.section.mob.wolf.desc", 8, 500, null);
        MobInfoRegistry.register(MobFireflyCluster.class, "guidebook.section.mob.firefly_cluster.name", "guidebook.section.mob.firefly_cluster.desc", -1, -1, null);
        MobInfoRegistry.register(MobButterfly.class, "guidebook.section.mob.butterfly.name", "guidebook.section.mob.butterfly.desc", -1, -1, null);
        MobInfoRegistry.register(MobZombie.class, "guidebook.section.mob.zombie.name", "guidebook.section.mob.zombie.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Items.CLOTH), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobZombieArmored.class, "guidebook.section.mob.armored_zombie.name", "guidebook.section.mob.armored_zombie.desc", 40, 1000, new MobDrop[]{new MobDrop(new ItemStack(Items.CLOTH), 1.0f, 1, 2), new MobDrop(new ItemStack(Items.CHAINLINK), 0.8f, 1, 4)});
        MobInfoRegistry.register(MobSnowman.class, "guidebook.section.mob.snowman.name", "guidebook.section.mob.snowman.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Items.AMMO_SNOWBALL), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobCreeper.class, "guidebook.section.mob.creeper.name", "guidebook.section.mob.creeper.desc", 20, 800, new MobDrop[]{new MobDrop(new ItemStack(Items.GUNPOWDER), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobSkeleton.class, "guidebook.section.mob.skeleton.name", "guidebook.section.mob.skeleton.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Items.BONE), 0.66f, 1, 2), new MobDrop(new ItemStack(Items.AMMO_ARROW), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobSpider.class, "guidebook.section.mob.spider.name", "guidebook.section.mob.spider.desc", 20, 200, new MobDrop[]{new MobDrop(new ItemStack(Items.STRING), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobSlime.class, "guidebook.section.mob.slime.name", "guidebook.section.mob.slime.desc", -1, 100, new MobDrop[]{new MobDrop(new ItemStack(Items.SLIMEBALL), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobGhast.class, "guidebook.section.mob.ghast.name", "guidebook.section.mob.ghast.desc", 20, 1000, new MobDrop[]{new MobDrop(new ItemStack(Items.GUNPOWDER), 0.66f, 1, 2)});
        MobInfoRegistry.register(MobZombiePig.class, "guidebook.section.mob.zombie_pigman.name", "guidebook.section.mob.zombie_pigman.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Items.FOOD_PORKCHOP_RAW), 0.297f, 1, 2), new MobDrop(new ItemStack(Items.ORE_RAW_GOLD), 0.0264f, 1, 2), new MobDrop(new ItemStack(Items.TOOL_SWORD_GOLD), 0.0066f, 1, 1)});
    }

    public static class MobInfo {
        private final Class<? extends Entity> entityClass;
        private final String nameTranslationKey;
        private final String descriptionTranslationKey;
        private final int health;
        private final int score;
        private final MobDrop[] drops;

        public MobInfo(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
            this.entityClass = entityClass;
            this.nameTranslationKey = nameTranslationKey;
            this.descriptionTranslationKey = descriptionTranslationKey;
            this.health = health;
            this.score = score;
            this.drops = drops;
        }

        public Class<? extends Entity> getEntityClass() {
            return this.entityClass;
        }

        public EntityRenderer<?> getRenderer() {
            return EntityRenderDispatcher.instance.getRenderer(this.entityClass);
        }

        public String getNameTranslationKey() {
            return this.nameTranslationKey;
        }

        public String getDescriptionTranslationKey() {
            return this.descriptionTranslationKey;
        }

        public int getHealth() {
            return this.health;
        }

        public int getScore() {
            return this.score;
        }

        public MobDrop[] getDrops() {
            return this.drops;
        }
    }

    public static class MobDrop {
        private final ItemStack dropStack;
        private final float dropChance;
        private final int minAmount;
        private final int maxAmount;

        public MobDrop(ItemStack dropStack, float dropChance, int minAmount, int maxAmount) {
            this.dropStack = dropStack;
            this.dropChance = dropChance;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public ItemStack getStack() {
            return this.dropStack;
        }

        public float getChance() {
            return this.dropChance;
        }

        public int getMinAmount() {
            return this.minAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }
}

