/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import org.lwjgl.opengl.GL11;

public class HudIngameDoom
extends HudIngame {
    private static final int[] NUMBER_WIDTHS = new int[]{9, 7, 9, 9, 11, 9, 9, 9, 9, 9};
    private static final int[] NUMBER_US = new int[]{0, 9, 16, 25, 34, 45, 54, 63, 72, 81};

    public HudIngameDoom(Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public void renderGameOverlay(float partialTicks, boolean flag, int mouseX, int mouseY) {
        float portalIntensity;
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            return;
        }
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        this.mc.worldRenderer.setupScaledResolution();
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        if (this.mc.gameSettings.immersiveMode.drawVignette() && ((Boolean)this.mc.gameSettings.vignette.value).booleanValue()) {
            this.renderVignette(this.mc.thePlayer.getBrightness(partialTicks), width, height);
        }
        ItemStack headSlotItem = this.mc.thePlayer.getItemInArmorSlot(HumanArmorShape.HEAD);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && headSlotItem != null && (headSlotItem.itemID == Blocks.PUMPKIN_CARVED_IDLE.id() || headSlotItem.itemID == Blocks.PUMPKIN_REDSTONE.id())) {
            this.renderPumpkinBlur(width, height);
        }
        if ((portalIntensity = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * partialTicks) > 0.0f) {
            this.renderPortalOverlay(portalIntensity, width, height);
        }
        this.drawBackground();
        this.drawFace();
        this.drawAmmo();
        this.drawHealth();
        this.drawArmsButtons();
        this.drawArmor();
        this.drawHotbarIndicator();
        this.drawStacks();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.mc.gameSettings.immersiveMode.drawCrosshair() && (Integer)this.mc.gameSettings.thirdPersonView.value == 0) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(775, 769);
            this.drawGuiIcon(width / 2 - 7, height / 2 - 7, 15, 15, TextureRegistry.getTexture("minecraft:gui/hud/crosshair"));
            GL11.glDisable(3042);
        }
    }

    private void drawBackground() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/hud/doom.png").bind();
        this.drawTexturedModalRectDouble((double)width / 2.0 - 197.0, height - 43, 0.0, 0.0, 197.0, 43.0, 0.00390625, 0.00390625, 0.0);
        this.drawTexturedModalRectDouble((double)width / 2.0, height - 43, 0.0, 43.0, 197.0, 43.0, 0.00390625, 0.00390625, 0.0);
        int loops = (int)Math.ceil(((double)width / 2.0 - 197.0) / 128.0);
        for (int i = 0; i < loops; ++i) {
            this.drawTexturedModalRectDouble((double)width / 2.0 - 197.0 - (double)(128 * (i + 1)), height - 43, 0.0, 86.0, 128.0, 43.0, 128.0, 43.0, 0.00390625, 0.00390625);
            this.drawTexturedModalRectDouble((double)width / 2.0 + 197.0 + (double)(128 * i), height - 43, 0.0, 86.0, 128.0, 43.0, 128.0, 43.0, 0.00390625, 0.00390625);
        }
    }

    private void drawFace() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        Face face = Face.NEUTRAL;
        if (this.mc.thePlayer.getGamemode().isPlayerInvulnerable()) {
            face = Face.GOD;
        } else if (this.mc.thePlayer.getHealth() == 0) {
            face = Face.DEAD;
        } else if (this.mc.thePlayer.hurtTime > 0) {
            face = Face.PAIN;
        } else if (this.updateCounter % 200 > 175) {
            face = Face.LOOK_RIGHT;
        } else if (this.updateCounter % 200 > 150) {
            face = Face.LOOK_LEFT;
        }
        this.drawTexturedModalRect(width / 2 - 16, height - 36, face.u, face.v, 32, 32);
    }

    private void drawAmmo() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        ItemStack stack = this.mc.thePlayer.getHeldItem();
        if (stack == null) {
            return;
        }
        int ammo = stack.stackSize;
        this.drawNumber(ammo, width / 2 - 160, height - 32);
    }

    private void drawHealth() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        float healthPercentage = (float)this.mc.thePlayer.getHealth() / (float)this.mc.thePlayer.getMaxHealth();
        int health = (int)(healthPercentage * 100.0f);
        if (health < 0) {
            health = 0;
        }
        this.drawNumber(health, width / 2 - 116, height - 32);
    }

    private void drawNumber(int i, int x, int y) {
        int digit;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/hud/doom.png").bind();
        IntArrayList parts = new IntArrayList();
        int prev = 0;
        int mult = 1;
        while (i / mult != 0) {
            int lowerDigits = i % (mult * 10);
            digit = lowerDigits - prev;
            prev += digit;
            parts.add(digit / mult);
            mult *= 10;
        }
        for (int j = 0; j < parts.size(); ++j) {
            digit = parts.getInt(j);
            int width = NUMBER_WIDTHS[digit];
            int u = NUMBER_US[digit];
            int v = 209;
            this.drawTexturedModalRect(x -= width, y, u, v, width, 15);
            --x;
        }
    }

    private void drawArmsButtons() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int i = 1;
        int activeSlot = this.mc.thePlayer.inventory.getCurrentItemIndex() % 9;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (i >= 10) continue;
                int px = width / 2 - 90 + 14 * x;
                int py = height - 38 + 14 * y;
                this.drawArmsButton(px, py, i, i - 1 == activeSlot);
                ++i;
            }
        }
    }

    private void drawArmsButton(int x, int y, int number, boolean active) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/hud/doom.png").bind();
        int u = 13;
        int v = 196;
        int textColor = -1;
        if (active) {
            u = 0;
            textColor = -6250336;
        }
        this.drawTexturedModalRect(x, y, u, v, 13, 13);
        this.drawStringShadow(this.fontRenderer, Integer.toString(number % 10), x + 4, y + 3, textColor);
    }

    private void drawArmor() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        float armorPercentage = (float)this.mc.thePlayer.getPlayerProtectionAmount() / 20.0f;
        int armor = (int)(armorPercentage * 100.0f);
        this.drawNumber(armor, width / 2 + 48, height - 32);
    }

    private void drawHotbarIndicator() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int x = width / 2 + 76;
        int y = height - 36;
        int selectedHotbar = (this.mc.thePlayer.inventory.getHotbarOffset() + 27) % 36 / 9;
        this.drawTexturedModalRect(x, y + 9 * selectedHotbar, 0, 129, 6, 6);
    }

    private void drawStacks() {
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int currentItem = this.mc.thePlayer.inventory.getCurrentItemIndex();
        int wrappedCurrentItem = this.mc.thePlayer.inventory.getCurrentItemIndex() % 9;
        int offset = 0;
        if (wrappedCurrentItem >= 5) {
            offset = 3 - (8 - wrappedCurrentItem);
        }
        int q = 0;
        for (int i = currentItem - offset; i < currentItem - offset + 4; ++i) {
            ItemStack stack = this.mc.thePlayer.inventory.getItem(i);
            int x = width / 2 + 94;
            int y = height - 37 + q * 9;
            this.drawItemStack(stack, x, y, i == currentItem);
            ++q;
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, boolean selected) {
        if (stack == null) {
            return;
        }
        String name = stack.getDisplayName();
        if (name.length() >= 10) {
            name = name.substring(0, 10);
        }
        name = name.toUpperCase();
        if (selected) {
            this.drawStringShadow(this.fontRenderer, TextFormatting.get(stack.getDisplayColor()) + name, x, y, -1);
        } else {
            this.drawStringNoShadow(this.fontRenderer, name, x, y, -12566464);
        }
        int maxStackSize = stack.getMaxStackSize();
        int stackSize = stack.stackSize;
        if (stackSize < 10) {
            this.drawStringShadow(this.fontRenderer, Integer.toString(stackSize), x + 70, y, -96);
        } else {
            this.drawStringShadow(this.fontRenderer, Integer.toString(stackSize), x + 64, y, -96);
        }
        if (maxStackSize < 10) {
            this.drawStringShadow(this.fontRenderer, Integer.toString(maxStackSize), x + 88, y, -96);
        } else {
            this.drawStringShadow(this.fontRenderer, Integer.toString(maxStackSize), x + 82, y, -96);
        }
    }

    private static enum Face {
        NEUTRAL(0, 224),
        LOOK_RIGHT(32, 224),
        LOOK_LEFT(64, 224),
        GRIN(96, 224),
        PAIN(128, 224),
        BIG_PAIN(160, 224),
        GOD(192, 224),
        DEAD(224, 224);

        public final int u;
        public final int v;

        private Face(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }
}

