/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicStairs;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.DisplayPos;

public class BlockModelStairs<T extends BlockLogicStairs>
extends BlockModelStandard<T> {
    protected static final DisplayPos STAIRS_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos STAIRS_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos STAIRS_THIRD_PERSON_LEFT_HAND = new DisplayPos(0.0f, 0.15625f, 0.0f, 75.0f, -135.0f, 0.0f, 0.375f, 0.375f, 0.375f);
    protected BlockModelStandard<T> parentModel;

    public BlockModelStairs(Block<T> block) {
        super(block);
        this.parentModel = (BlockModelStandard)BlockModelDispatcher.getInstance().getDispatch(((BlockLogicStairs)this.block.getLogic()).modelBlock);
        this.blockTextures.copy(this.parentModel.blockTextures);
        this.overbrightTextures.copy(this.parentModel.overbrightTextures);
        this.retroBlockTextures.copy(this.parentModel.retroBlockTextures);
        this.retroOverbrightTextures.copy(this.parentModel.retroOverbrightTextures);
        this.setDisplayPos("gui", STAIRS_GUI);
        this.setDisplayPos("head", STAIRS_HEAD);
        this.setDisplayPos("thirdperson_lefthand", STAIRS_THIRD_PERSON_LEFT_HAND);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        int hRotation = meta & 3;
        int vRotation = meta & 8;
        float stepYOffset = vRotation > 0 ? 0.5f : 0.0f;
        AABB bounds = AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (hRotation == 0) {
            bounds.set(0.0, 0.0f + stepYOffset, 0.0, 0.5, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else if (hRotation == 1) {
            bounds.set(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else if (hRotation == 2) {
            bounds.set(0.0, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else {
            bounds.set(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.0f + stepYOffset, 0.5, 1.0, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelStairs.renderBlocks.useInventoryTint) {
            int j = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f(f1 * brightness, f3 * brightness, f5 * brightness, alpha);
        }
        for (int l = 0; l < 2; ++l) {
            AABB bounds = l == 0 ? AABB.fromPool(0.0, 0.0, 0.0, 1.0, 0.5, 1.0) : AABB.fromPool(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
            GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            GL11.glTranslatef(0.5f, 0.5f, 0.5f);
        }
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.parentModel.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.parentModel.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    public int renderLayer() {
        return this.parentModel.renderLayer();
    }
}

