/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.gamerule;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.data.gamerule.GameRule;
import org.jetbrains.annotations.NotNull;

public class GameRuleInteger
extends GameRule<Integer> {
    public GameRuleInteger(String key, Integer defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag tag, Integer value) {
        IntTag ruleTag = new IntTag(value);
        tag.put(this.getKey(), ruleTag);
    }

    @Override
    public Integer readFromNBT(@NotNull CompoundTag tag) {
        Tag<?> ruleTag = tag.getTag(this.getKey());
        if (ruleTag instanceof IntTag) {
            return (Integer)((IntTag)ruleTag).getValue();
        }
        return (Integer)this.getDefaultValue();
    }

    @Override
    public Integer parseFromString(@NotNull String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return (Integer)this.getDefaultValue();
        }
    }
}

