/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class ParticleWaterDrop
extends Particle {
    public ParticleWaterDrop(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.3;
        this.yd = (float)Math.random() * 0.2f + 0.1f;
        this.zd *= 0.3;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.tex = TextureRegistry.getTexture("minecraft:particle/splash_rain_" + this.random.nextInt(4));
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void tick() {
        double y0;
        Material m;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.remove();
            }
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
        if (((m = this.world.getBlockMaterial(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z))).isLiquid() || m.isSolid()) && this.y < (y0 = (double)((float)(MathHelper.floor(this.y) + 1) - BlockLogicFluid.getHeight(this.world.getBlockMetadata(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)))))) {
            this.remove();
        }
    }
}

