/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.render.texturepack.ManifestBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class TexturePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    public String packId;
    public String fileName;
    public ManifestBase manifest;

    public void readZipFile() {
    }

    public void closeTexturePackFile() {
    }

    public void readTexturePackManifest() throws IOException {
    }

    public void disposeOfTexturePack(Minecraft minecraft) {
    }

    public void bindThumbnailTexture(Minecraft minecraft) {
    }

    @Nullable
    public InputStream getResourceAsStream(String s) {
        if (Holidays.getCurrentThemedHoliday() != null && ((Boolean)Minecraft.getMinecraft().gameSettings.enableHolidayTextures.value).booleanValue()) {
            assert (Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() != null) : "Current themed holiday must have a theme!";
            String holidayPath = ("/holidays/" + Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() + "/" + s).replace("//", "/");
            InputStream holidayStream = TexturePack.class.getResourceAsStream(holidayPath);
            if (holidayStream != null) {
                return holidayStream;
            }
        }
        return TexturePack.class.getResourceAsStream(s);
    }

    protected String[] getFilesInDirectory(String directory) {
        ArrayList<String> paths;
        block15: {
            paths = new ArrayList<String>();
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            try {
                Path myPath;
                URL url = TexturePack.class.getResource(directory);
                if (url == null) break block15;
                URI uri = url.toURI();
                FileSystem fileSystem = null;
                if (uri.getScheme().equals("jar")) {
                    try {
                        fileSystem = FileSystems.getFileSystem(uri);
                    }
                    catch (Exception e) {
                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    myPath = fileSystem.getPath(directory, new String[0]);
                } else {
                    myPath = Paths.get(uri);
                }
                try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                    Iterator it = walk.iterator();
                    it.next();
                    while (it.hasNext()) {
                        paths.add(directory + ((Path)it.next()).getFileName().toString());
                    }
                }
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while loading all files in directory '{}' at '{}'!", directory, this.packId, e);
            }
        }
        return paths.toArray(new String[0]);
    }

    public abstract boolean hasFile(String var1);
}

