/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMoss
extends BlockLogic
implements IBonemealable {
    public static Int2IntArrayMap variantMap = new Int2IntArrayMap();
    public static final Map<Block<?>, Block<?>> stoneToMossMap = new HashMap();
    public static final Map<Block<?>, Block<?>> mossToStoneMap = new HashMap();

    public BlockLogicMoss(Block<?> block, Block<?> parentBlock) {
        super(block, Material.moss);
        block.setTicking(true);
        variantMap.put(parentBlock.id(), block.id());
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        Block<?> mossStone;
        int rZ;
        int rY;
        Side randomSide;
        int rX;
        if (world.isClientSide) {
            return;
        }
        if (world.areBlocksLoaded(x, y, z, 16) && rand.nextInt(20) == 0 && this.airExposed(world, x, y, z) && this.canMossSpread(world, rX = x + (randomSide = Side.getSideById(rand.nextInt(6))).getOffsetX(), rY = y + randomSide.getOffsetY(), rZ = z + randomSide.getOffsetZ()) && (mossStone = BlockLogicMoss.getMossBlock(world.getBlockId(rX, rY, rZ))) != null) {
            world.setBlockWithNotify(rX, rY, rZ, mossStone.id());
        }
    }

    public boolean canMossSpread(World world, int x, int y, int z) {
        if (!world.isBlockLoaded(x, y, z)) {
            return false;
        }
        int maxBlockLight = 0;
        int maxSkyLight = 0;
        for (int i = 0; i < Side.sides.length; ++i) {
            Side s = Side.sides[i];
            int blockLight = world.getBlockLightValue(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ());
            int skyLight = world.getSavedLightValue(LightLayer.Sky, x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ());
            if (blockLight > maxBlockLight) {
                maxBlockLight = blockLight;
            }
            if (skyLight <= maxSkyLight) continue;
            maxSkyLight = skyLight;
        }
        return maxBlockLight == 0 && maxSkyLight == 0;
    }

    @Nullable
    public static Block<?> getMossBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockLogicMoss.getMossBlock(Blocks.blocksList[blockId]);
    }

    public static Block<?> getMossBlock(Block<?> stoneBlock) {
        return stoneToMossMap.get(stoneBlock);
    }

    public static Block<?> getStoneBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockLogicMoss.getStoneBlock(Blocks.blocksList[blockId]);
    }

    public static Block<?> getStoneBlock(Block<?> mossBlock) {
        return mossToStoneMap.get(mossBlock);
    }

    public static void initMossMap() {
        stoneToMossMap.clear();
        mossToStoneMap.clear();
        stoneToMossMap.put(Blocks.STONE, Blocks.MOSS_STONE);
        stoneToMossMap.put(Blocks.GRANITE, Blocks.MOSS_GRANITE);
        stoneToMossMap.put(Blocks.LIMESTONE, Blocks.MOSS_LIMESTONE);
        stoneToMossMap.put(Blocks.BASALT, Blocks.MOSS_BASALT);
        stoneToMossMap.put(Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY);
        stoneToMossMap.put(Blocks.BRICK_STONE_POLISHED, Blocks.BRICK_STONE_POLISHED_MOSSY);
        stoneToMossMap.put(Blocks.LOG_OAK, Blocks.LOG_OAK_MOSSY);
        for (Map.Entry<Block<?>, Block<?>> entry : stoneToMossMap.entrySet()) {
            mossToStoneMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            if (!this.canMossSpread(world, blockX, blockY, blockZ) || !this.airExposed(world, blockX, blockY, blockZ)) {
                return false;
            }
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
            for (int j1 = 0; j1 < 32; ++j1) {
                Block<?> block;
                int randomBlockX = blockX;
                int randomBlockY = blockY;
                int randomBlockZ = blockZ;
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    randomBlockX += world.rand.nextInt(3) - 1;
                    randomBlockY += (world.rand.nextInt(3) - 1) * world.rand.nextInt(3) / 2;
                    randomBlockZ += world.rand.nextInt(3) - 1;
                }
                if (!this.airExposed(world, randomBlockX, randomBlockY, randomBlockZ) || !this.canMossSpread(world, randomBlockX, randomBlockY, randomBlockZ) || (block = BlockLogicMoss.getMossBlock(world.getBlockId(randomBlockX, randomBlockY, randomBlockZ))) == null) continue;
                world.setBlockWithNotify(randomBlockX, randomBlockY, randomBlockZ, block.id());
            }
        }
        return true;
    }

    public boolean airExposed(@NotNull World world, int x, int y, int z) {
        for (int i = 0; i < Side.sides.length; ++i) {
            Side s = Side.sides[i];
            if (!world.isAirBlock(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ())) continue;
            return true;
        }
        return false;
    }
}

