/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.linalg;

import java.util.Objects;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.linalg.Vector4;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vector3
implements Poolable<Vector3> {
    @NotNull
    private static final ObjectPool<Vector3> POOL = new ObjectPool<Vector3>(Vector3::new);
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    @NotNull
    public static Vector3 fromPool(double x, double y, double z) {
        return POOL.get().set(x, y, z);
    }

    @NotNull
    public static Vector3 unitX() {
        return Vector3.fromPool(1.0, 0.0, 0.0);
    }

    @NotNull
    public static Vector3 unitY() {
        return Vector3.fromPool(0.0, 1.0, 0.0);
    }

    @NotNull
    public static Vector3 unitZ() {
        return Vector3.fromPool(0.0, 0.0, 1.0);
    }

    private Vector3() {
    }

    @Override
    @NotNull
    public ObjectPool<Vector3> getPool() {
        return POOL;
    }

    @Override
    public void set(@NotNull Vector3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    @NotNull
    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public Vector4 extend(double w) {
        return Vector4.fromPool(this.x, this.y, this.z, w);
    }

    @NotNull
    public Vector3 cross(@NotNull Vector3 other) {
        return Vector3.fromPool(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    @NotNull
    public Vector3 neg() {
        return ((Vector3)this.copyPooled()).negInPlace();
    }

    @NotNull
    public Vector3 negInPlace() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @NotNull
    public Vector3 add(@NotNull Vector3 other) {
        return ((Vector3)this.copyPooled()).addInPlace(other);
    }

    @NotNull
    public Vector3 addInPlace(@NotNull Vector3 other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    @NotNull
    public Vector3 sub(@NotNull Vector3 other) {
        return ((Vector3)this.copyPooled()).subInPlace(other);
    }

    @NotNull
    public Vector3 subInPlace(@NotNull Vector3 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public double @NotNull [] asArray() {
        return new double[]{this.x, this.y, this.z};
    }

    @NotNull
    public Vector3 mult(double value) {
        return ((Vector3)this.copyPooled()).multInPlace(value);
    }

    @NotNull
    public Vector3 multInPlace(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        return this;
    }

    @NotNull
    public Vector3 div(double value) {
        return ((Vector3)this.copyPooled()).divInPlace(value);
    }

    @NotNull
    public Vector3 divInPlace(double value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        return this;
    }

    public double dot(@NotNull Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public double squaredMagnitude() {
        return this.dot(this);
    }

    public double magnitude() {
        return Math.sqrt(this.squaredMagnitude());
    }

    public double angle(@NotNull Vector3 other) {
        return Math.atan2(this.cross(other).magnitude(), this.dot(other));
    }

    @NotNull
    public Vector3 normalize() {
        return this.normalize(1.0);
    }

    @NotNull
    public Vector3 normalize(double magnitude) {
        return this.mult(magnitude / this.magnitude());
    }

    public double squaredDistance(@NotNull Vector3 other) {
        return other.sub(this).squaredMagnitude();
    }

    public double distance(@NotNull Vector3 other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @NotNull
    public Vector3 lerp(@NotNull Vector3 other, double amount) {
        return Vector3.fromPool(this.x + (other.x - this.x) * amount, this.y + (other.y - this.y) * amount, this.z + (other.z - this.z) * amount);
    }

    @Nullable
    public Vector3 clipX(@NotNull Vector3 other, double x) {
        @NotNull Vector3 delta = other.sub(this);
        if (delta.x * delta.x < 1.0E-7) {
            return null;
        }
        double percentage = x - this.x - delta.x;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector3.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage);
    }

    @Nullable
    public Vector3 clipY(@NotNull Vector3 other, double y) {
        @NotNull Vector3 delta = other.sub(this);
        if (delta.y * delta.y < 1.0E-7) {
            return null;
        }
        double percentage = y - this.y - delta.y;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector3.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage);
    }

    @Nullable
    public Vector3 clipZ(@NotNull Vector3 other, double z) {
        @NotNull Vector3 delta = other.sub(this);
        if (delta.z * delta.z < 1.0E-7) {
            return null;
        }
        double percentage = z - this.z - delta.z;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector3.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage);
    }

    @NotNull
    public Vector3 rotX(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        return Vector3.fromPool(this.x, this.y * (double)cos + this.z * (double)sin, this.z * (double)cos - this.y * (double)sin);
    }

    @NotNull
    public Vector3 rotY(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        return Vector3.fromPool(this.x * (double)cos + this.z * (double)sin, this.y, this.z * (double)cos - this.x * (double)sin);
    }

    @NotNull
    public Vector3 rotZ(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        return Vector3.fromPool(this.x * (double)cos + this.y * (double)sin, this.y * (double)cos - this.x * (double)sin, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector3) {
            @NotNull Vector3 other = (Vector3)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    @NotNull
    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + " ]";
    }
}

