/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPainting
extends Item {
    public ItemPainting(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    @Nullable
    public ItemStack onUseItem(@NotNull ItemStack itemstack, @NotNull World world, @NotNull Player entityplayer) {
        if (!world.isClientSide && !entityplayer.isSneaking()) {
            entityplayer.displayPaintingPickerScreen();
        }
        return itemstack;
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        EntityPainting entity;
        int sideHit = side.getId();
        if (sideHit == 0) {
            return false;
        }
        if (sideHit == 1) {
            return false;
        }
        int direction = 0;
        if (sideHit == 4) {
            direction = 1;
        }
        if (sideHit == 3) {
            direction = 2;
        }
        if (sideHit == 5) {
            direction = 3;
        }
        if ((entity = new EntityPainting(world, blockX, blockY, blockZ, direction, player.getSelectedArt().key)).canStay()) {
            if (!world.isClientSide) {
                world.entityJoinedWorld(entity);
            }
            world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(player);
            return true;
        }
        return false;
    }
}

