/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentTypeBool;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeGameruleGeneric;
import net.minecraft.core.net.packet.PacketGameRule;

public class CommandGameRule
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        ArgumentBuilderLiteral argumentBuilder = (ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("gamerule").requires(CommandSource::hasAdmin);
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            ArgumentBuilderRequired gameRuleValueArgument = gameRule instanceof GameRuleBoolean ? (ArgumentBuilderRequired)ArgumentBuilderRequired.argument("value", ArgumentTypeBool.bool()).executes(c -> {
                ((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules().setValue((GameRuleBoolean)gameRule, ArgumentTypeBool.getBool(c, "value"));
                ((CommandSource)c.getSource()).sendPacketToAllPlayers(() -> new PacketGameRule(((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules()));
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.set", gameRule.getKey(), ArgumentTypeBool.getBool(c, "value"));
                return 1;
            }) : (ArgumentBuilderRequired)ArgumentBuilderRequired.argument("value", ArgumentTypeGameruleGeneric.gameRule(gameRule)).executes(c -> {
                Object o = c.getArgument("value", Object.class);
                ((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules().setValue(gameRule, o);
                ((CommandSource)c.getSource()).sendPacketToAllPlayers(() -> new PacketGameRule(((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules()));
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.set", gameRule.getKey(), o);
                return 1;
            });
            argumentBuilder.then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal(gameRule.getKey()).executes(c -> {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.get", gameRule.getKey(), ((CommandSource)c.getSource()).getWorld().getGameRuleValue(gameRule));
                return 1;
            })).then(gameRuleValueArgument));
        }
        LiteralCommandNode<CommandSource> commandNode = dispatcher.register(argumentBuilder);
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("gr").requires(CommandSource::hasAdmin)).redirect(commandNode));
    }
}

