/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class MobRendererButterfly
extends EntityRenderer<MobButterfly> {
    private static final Random sizeRandom = new Random();

    @Override
    public void render(@NotNull Tessellator tessellator, @NotNull MobButterfly butterfly, double x, double y, double z, float yaw, float partialTick) {
        sizeRandom.setSeed((long)butterfly.getSkinVariant() << 16);
        float scale = 0.45f + sizeRandom.nextFloat() * 0.35f;
        float yRot = MathHelper.lerp(butterfly.yRotO, butterfly.yRot, partialTick);
        MobRendererButterfly.drawButterfly(tessellator, butterfly.tickCount, scale, yRot, x, y, z, partialTick, this.renderDispatcher.textureManager, MobRendererButterfly.getTexture(butterfly));
    }

    @Override
    public void renderPreview(@NotNull Tessellator tessellator, @NotNull MobButterfly butterfly, double x, double y, double z, float yaw, float partialTick) {
        float yRot = MathHelper.lerp(butterfly.yRotO, butterfly.yRot, partialTick);
        MobRendererButterfly.drawButterfly(tessellator, butterfly.tickCount, 1.25f, -yRot, x, y + 0.5, z, partialTick, this.renderDispatcher.textureManager, MobRendererButterfly.getTexture(butterfly));
    }

    public static void drawButterfly(Tessellator tessellator, int ticksAlive, float scale, float yRot, double x, double y, double z, float partialTick, TextureManager textureManager, String texture) {
        textureManager.bindTexture(textureManager.loadTexture(texture));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y + 0.25f, (float)z);
        GL11.glEnable(32826);
        GL11.glDisable(2884);
        GL11.glDisable(2896);
        GL11.glScalef(0.5f * scale, 0.5f * scale, 0.5f * scale);
        GL11.glRotatef(yRot, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-22.5f, 1.0f, 0.0f, 0.0f);
        float xOff = -0.5f;
        float zOff = -0.5f;
        float flapAngle = (MathHelper.sin((float)ticksAlive + partialTick) + 1.0f) * 22.5f + 5.0f;
        GL11.glPushMatrix();
        GL11.glRotatef(-flapAngle, 0.0f, 0.0f, 1.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-0.5, 0.0, -0.5, 0.0, 1.0);
        tessellator.addVertexWithUV(0.0, 0.0, -0.5, 0.5, 1.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.5, 0.5, 0.0);
        tessellator.addVertexWithUV(-0.5, 0.0, 0.5, 0.0, 0.0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef(flapAngle, 0.0f, 0.0f, 1.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, 0.0, -0.5, 0.5, 1.0);
        tessellator.addVertexWithUV(0.5, 0.0, -0.5, 1.0, 1.0);
        tessellator.addVertexWithUV(0.5, 0.0, 0.5, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.5, 0.5, 0.0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glDisable(32826);
        GL11.glEnable(2884);
        GL11.glEnable(2896);
        GL11.glPopMatrix();
    }

    public static String getTexture(MobButterfly butterfly) {
        if (!((Boolean)Minecraft.getMinecraft().gameSettings.mobVariants.value).booleanValue()) {
            return butterfly.getDefaultEntityTexture();
        }
        return butterfly.getEntityTexture();
    }
}

