/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.phys;

import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;

public class Vec3
implements Poolable<Vec3> {
    @NotNull
    private static final ObjectPool<Vec3> POOL = new ObjectPool<Vec3>(() -> new Vec3(0.0, 0.0, 0.0));
    public double x;
    public double y;
    public double z;

    @Deprecated
    public static Vec3 getPermanentVec3(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Deprecated
    public static void deinitializePool() {
        POOL.free();
    }

    @Deprecated
    public static void initializePool() {
        POOL.reset();
    }

    @Deprecated
    public static Vec3 getTempVec3(double x, double y, double z) {
        return POOL.get().set(x, y, z);
    }

    @NotNull
    public static Vec3 fromPool(double x, double y, double z) {
        return POOL.get().set(x, y, z);
    }

    @Deprecated
    public Vec3 makePermanent() {
        return (Vec3)this.copyUnpooled();
    }

    private Vec3(double x, double y, double z) {
        if (x == -0.0) {
            x = 0.0;
        }
        if (y == -0.0) {
            y = 0.0;
        }
        if (z == -0.0) {
            z = 0.0;
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @NotNull
    public ObjectPool<Vec3> getPool() {
        return POOL;
    }

    @Override
    public void set(@NotNull Vec3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public Vec3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3 vectorTo(Vec3 vec3) {
        return Vec3.fromPool(vec3.x - this.x, vec3.y - this.y, vec3.z - this.z);
    }

    public Vec3 normalize() {
        double d = MathHelper.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d < 1.0E-4) {
            return Vec3.fromPool(0.0, 0.0, 0.0);
        }
        return this.scale(1.0 / d);
    }

    public double dotProduct(Vec3 vec3) {
        return this.x * vec3.x + this.y * vec3.y + this.z * vec3.z;
    }

    public Vec3 crossProduct(Vec3 vec3) {
        return Vec3.fromPool(this.y * vec3.z - this.z * vec3.y, this.z * vec3.x - this.x * vec3.z, this.x * vec3.y - this.y * vec3.x);
    }

    public Vec3 add(double x, double y, double z) {
        return Vec3.fromPool(this.x + x, this.y + y, this.z + z);
    }

    public Vec3 scale(double scalar) {
        return Vec3.fromPool(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public double distanceTo(Vec3 vec3) {
        double diffX = vec3.x - this.x;
        double diffY = vec3.y - this.y;
        double diffZ = vec3.z - this.z;
        return MathHelper.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
    }

    public double distanceToSquared(Vec3 vec3) {
        double diffX = vec3.x - this.x;
        double diffY = vec3.y - this.y;
        double diffZ = vec3.z - this.z;
        return diffX * diffX + diffY * diffY + diffZ * diffZ;
    }

    public double distanceToSquared(double x, double y, double z) {
        double diffX = x - this.x;
        double diffY = y - this.y;
        double diffZ = z - this.z;
        return diffX * diffX + diffY * diffY + diffZ * diffZ;
    }

    public double length() {
        return MathHelper.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3 clipX(Vec3 vec3, double d) {
        double diffX = vec3.x - this.x;
        double diffY = vec3.y - this.y;
        double diffZ = vec3.z - this.z;
        if (diffX * diffX < 1.0E-7) {
            return null;
        }
        double d4 = (d - this.x) / diffX;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3.fromPool(this.x + diffX * d4, this.y + diffY * d4, this.z + diffZ * d4);
    }

    public Vec3 clipY(Vec3 vec3, double d) {
        double diffX = vec3.x - this.x;
        double diffY = vec3.y - this.y;
        double diffZ = vec3.z - this.z;
        if (diffY * diffY < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - this.y) / diffY;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3.fromPool(this.x + diffX * d4, this.y + diffY * d4, this.z + diffZ * d4);
    }

    public Vec3 clipZ(Vec3 vec3, double d) {
        double diffX = vec3.x - this.x;
        double diffY = vec3.y - this.y;
        double diffZ = vec3.z - this.z;
        if (diffZ * diffZ < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - this.z) / diffZ;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3.fromPool(this.x + diffX * d4, this.y + diffY * d4, this.z + diffZ * d4);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vec3 lerp(Vec3 vec3, double progress) {
        return Vec3.fromPool(this.x + (vec3.x - this.x) * progress, this.y + (vec3.y - this.y) * progress, this.z + (vec3.z - this.z) * progress);
    }

    public void rotateAroundX(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        double x = this.x;
        double y = this.y * (double)cos + this.z * (double)sin;
        double z = this.z * (double)cos - this.y * (double)sin;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void rotateAroundY(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        double x = this.x * (double)cos + this.z * (double)sin;
        double y = this.y;
        double z = this.z * (double)cos - this.x * (double)sin;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void rotateAroundZ(float radians) {
        float cos = MathHelper.cos(radians);
        float sin = MathHelper.sin(radians);
        double x = this.x * (double)cos + this.y * (double)sin;
        double y = this.y * (double)cos - this.x * (double)sin;
        double z = this.z;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

