/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAnimMesh")
public class AIAnimMesh
extends Struct<AIAnimMesh>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MVERTICES;
    public static final int MNORMALS;
    public static final int MTANGENTS;
    public static final int MBITANGENTS;
    public static final int MCOLORS;
    public static final int MTEXTURECOORDS;
    public static final int MNUMVERTICES;
    public static final int MWEIGHT;

    protected AIAnimMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIAnimMesh create(long address, @Nullable ByteBuffer container) {
        return new AIAnimMesh(address, container);
    }

    public AIAnimMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIAnimMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIAnimMesh.nmName(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mVertices() {
        return AIAnimMesh.nmVertices(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mNormals() {
        return AIAnimMesh.nmNormals(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mTangents() {
        return AIAnimMesh.nmTangents(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mBitangents() {
        return AIAnimMesh.nmBitangents(this.address());
    }

    @NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]")
    public PointerBuffer mColors() {
        return AIAnimMesh.nmColors(this.address());
    }

    @Nullable
    @NativeType(value="struct aiColor4D *")
    public AIColor4D.Buffer mColors(int index) {
        return AIAnimMesh.nmColors(this.address(), index);
    }

    @NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]")
    public PointerBuffer mTextureCoords() {
        return AIAnimMesh.nmTextureCoords(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mTextureCoords(int index) {
        return AIAnimMesh.nmTextureCoords(this.address(), index);
    }

    @NativeType(value="unsigned int")
    public int mNumVertices() {
        return AIAnimMesh.nmNumVertices(this.address());
    }

    public float mWeight() {
        return AIAnimMesh.nmWeight(this.address());
    }

    public AIAnimMesh mName(@NativeType(value="struct aiString") AIString value) {
        AIAnimMesh.nmName(this.address(), value);
        return this;
    }

    public AIAnimMesh mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIAnimMesh mVertices(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh mNormals(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmNormals(this.address(), value);
        return this;
    }

    public AIAnimMesh mTangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmTangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mBitangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmBitangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(@NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
        AIAnimMesh.nmColors(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(int index, @Nullable @NativeType(value="struct aiColor4D *") AIColor4D.Buffer value) {
        AIAnimMesh.nmColors(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mColors(int index, Consumer<AIColor4D.Buffer> consumer) {
        consumer.accept(this.mColors(index));
        return this;
    }

    public AIAnimMesh mTextureCoords(@NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), value);
        return this;
    }

    public AIAnimMesh mTextureCoords(int index, @Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mTextureCoords(int index, Consumer<AIVector3D.Buffer> consumer) {
        consumer.accept(this.mTextureCoords(index));
        return this;
    }

    public AIAnimMesh mNumVertices(@NativeType(value="unsigned int") int value) {
        AIAnimMesh.nmNumVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh mWeight(float value) {
        AIAnimMesh.nmWeight(this.address(), value);
        return this;
    }

    public AIAnimMesh set(AIString mName, @Nullable AIVector3D.Buffer mVertices, @Nullable AIVector3D.Buffer mNormals, @Nullable AIVector3D.Buffer mTangents, @Nullable AIVector3D.Buffer mBitangents, PointerBuffer mColors, PointerBuffer mTextureCoords, int mNumVertices, float mWeight) {
        this.mName(mName);
        this.mVertices(mVertices);
        this.mNormals(mNormals);
        this.mTangents(mTangents);
        this.mBitangents(mBitangents);
        this.mColors(mColors);
        this.mTextureCoords(mTextureCoords);
        this.mNumVertices(mNumVertices);
        this.mWeight(mWeight);
        return this;
    }

    public AIAnimMesh set(AIAnimMesh src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIAnimMesh malloc() {
        return new AIAnimMesh(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIAnimMesh calloc() {
        return new AIAnimMesh(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIAnimMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIAnimMesh(MemoryUtil.memAddress(container), container);
    }

    public static AIAnimMesh create(long address) {
        return new AIAnimMesh(address, null);
    }

    @Nullable
    public static AIAnimMesh createSafe(long address) {
        return address == 0L ? null : new AIAnimMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIAnimMesh.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIAnimMesh.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIAnimMesh mallocStack() {
        return AIAnimMesh.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimMesh callocStack() {
        return AIAnimMesh.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimMesh mallocStack(MemoryStack stack) {
        return AIAnimMesh.malloc(stack);
    }

    @Deprecated
    public static AIAnimMesh callocStack(MemoryStack stack) {
        return AIAnimMesh.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIAnimMesh.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIAnimMesh.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.calloc(capacity, stack);
    }

    public static AIAnimMesh malloc(MemoryStack stack) {
        return new AIAnimMesh(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIAnimMesh calloc(MemoryStack stack) {
        return new AIAnimMesh(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    @Nullable
    public static AIVector3D.Buffer nmVertices(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress(struct + (long)MVERTICES), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmNormals(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress(struct + (long)MNORMALS), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmTangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress(struct + (long)MTANGENTS), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmBitangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress(struct + (long)MBITANGENTS), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmColors(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MCOLORS, 8);
    }

    @Nullable
    public static AIColor4D.Buffer nmColors(long struct, int index) {
        return AIColor4D.createSafe(MemoryUtil.memGetAddress(struct + (long)MCOLORS + Checks.check(index, 8) * (long)POINTER_SIZE), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmTextureCoords(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MTEXTURECOORDS, 8);
    }

    @Nullable
    public static AIVector3D.Buffer nmTextureCoords(long struct, int index) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress(struct + (long)MTEXTURECOORDS + Checks.check(index, 8) * (long)POINTER_SIZE), AIAnimMesh.nmNumVertices(struct));
    }

    public static int nmNumVertices(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMVERTICES);
    }

    public static float nmWeight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MWEIGHT);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmVertices(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MVERTICES, MemoryUtil.memAddressSafe(value));
    }

    public static void nmNormals(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MNORMALS, MemoryUtil.memAddressSafe(value));
    }

    public static void nmTangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTANGENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nmBitangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MBITANGENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nmColors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)MCOLORS, value.remaining() * POINTER_SIZE);
    }

    public static void nmColors(long struct, int index, @Nullable AIColor4D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCOLORS + Checks.check(index, 8) * (long)POINTER_SIZE, MemoryUtil.memAddressSafe(value));
    }

    public static void nmTextureCoords(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)MTEXTURECOORDS, value.remaining() * POINTER_SIZE);
    }

    public static void nmTextureCoords(long struct, int index, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTEXTURECOORDS + Checks.check(index, 8) * (long)POINTER_SIZE, MemoryUtil.memAddressSafe(value));
    }

    public static void nmNumVertices(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMVERTICES, value);
    }

    public static void nmWeight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MWEIGHT, value);
    }

    static {
        Struct.Layout layout = AIAnimMesh.__struct(AIAnimMesh.__member(AIString.SIZEOF, AIString.ALIGNOF), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__array(POINTER_SIZE, 8), AIAnimMesh.__array(POINTER_SIZE, 8), AIAnimMesh.__member(4), AIAnimMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MVERTICES = layout.offsetof(1);
        MNORMALS = layout.offsetof(2);
        MTANGENTS = layout.offsetof(3);
        MBITANGENTS = layout.offsetof(4);
        MCOLORS = layout.offsetof(5);
        MTEXTURECOORDS = layout.offsetof(6);
        MNUMVERTICES = layout.offsetof(7);
        MWEIGHT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AIAnimMesh, Buffer>
    implements NativeResource {
        private static final AIAnimMesh ELEMENT_FACTORY = AIAnimMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIAnimMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIAnimMesh.nmName(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mVertices() {
            return AIAnimMesh.nmVertices(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mNormals() {
            return AIAnimMesh.nmNormals(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mTangents() {
            return AIAnimMesh.nmTangents(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mBitangents() {
            return AIAnimMesh.nmBitangents(this.address());
        }

        @NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]")
        public PointerBuffer mColors() {
            return AIAnimMesh.nmColors(this.address());
        }

        @Nullable
        @NativeType(value="struct aiColor4D *")
        public AIColor4D.Buffer mColors(int index) {
            return AIAnimMesh.nmColors(this.address(), index);
        }

        @NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]")
        public PointerBuffer mTextureCoords() {
            return AIAnimMesh.nmTextureCoords(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mTextureCoords(int index) {
            return AIAnimMesh.nmTextureCoords(this.address(), index);
        }

        @NativeType(value="unsigned int")
        public int mNumVertices() {
            return AIAnimMesh.nmNumVertices(this.address());
        }

        public float mWeight() {
            return AIAnimMesh.nmWeight(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIAnimMesh.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mVertices(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmVertices(this.address(), value);
            return this;
        }

        public Buffer mNormals(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmNormals(this.address(), value);
            return this;
        }

        public Buffer mTangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmTangents(this.address(), value);
            return this;
        }

        public Buffer mBitangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmBitangents(this.address(), value);
            return this;
        }

        public Buffer mColors(@NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
            AIAnimMesh.nmColors(this.address(), value);
            return this;
        }

        public Buffer mColors(int index, @Nullable @NativeType(value="struct aiColor4D *") AIColor4D.Buffer value) {
            AIAnimMesh.nmColors(this.address(), index, value);
            return this;
        }

        public Buffer mColors(int index, Consumer<AIColor4D.Buffer> consumer) {
            consumer.accept(this.mColors(index));
            return this;
        }

        public Buffer mTextureCoords(@NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), value);
            return this;
        }

        public Buffer mTextureCoords(int index, @Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), index, value);
            return this;
        }

        public Buffer mTextureCoords(int index, Consumer<AIVector3D.Buffer> consumer) {
            consumer.accept(this.mTextureCoords(index));
            return this;
        }

        public Buffer mNumVertices(@NativeType(value="unsigned int") int value) {
            AIAnimMesh.nmNumVertices(this.address(), value);
            return this;
        }

        public Buffer mWeight(float value) {
            AIAnimMesh.nmWeight(this.address(), value);
            return this;
        }
    }
}

