/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.opengl.GL11;

public class ItemElement
extends Gui {
    Minecraft mc;

    public ItemElement(Minecraft mc) {
        this.mc = mc;
    }

    public void render(ItemStack itemStack, int x, int y, boolean isSelected, Slot slot) {
        boolean hasDrawnSlotBackground = false;
        boolean discovered = true;
        Lighting.enableInventoryLight();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(32826);
        if (slot != null) {
            discovered = slot.getIsDiscovered(this.mc.thePlayer);
            if (slot.getItemIcon() != null) {
                IconCoordinate iconIndex = TextureRegistry.getTexture(slot.getItemIcon());
                if (itemStack == null) {
                    GL11.glDisable(2896);
                    this.drawTexturedIcon(x, y, 16, 16, iconIndex);
                    GL11.glEnable(2896);
                    hasDrawnSlotBackground = true;
                }
            }
            if (slot.isLocked()) {
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glDisable(2896);
                IconCoordinate iconCoordinate = TextureRegistry.getTexture("minecraft:gui/slot_locked");
                this.drawGuiIcon(x - 1, y - 1, 18, 18, iconCoordinate);
                GL11.glEnable(2896);
            }
        }
        if (!hasDrawnSlotBackground) {
            GL11.glEnable(2929);
            if (itemStack != null) {
                ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemStack.getItem());
                itemModel.renderGui(Tessellator.instance, null, itemStack, x, y, discovered ? 1.0f : 0.0f, 1.0f, 1.0f);
                if (slot instanceof SlotGuidebook) {
                    if (((SlotGuidebook)slot).recipe instanceof RecipeEntryTrommel && ((SlotGuidebook)slot).item != null && ((SlotGuidebook)slot).isOutput) {
                        WeightedRandomLootObject lootObject;
                        WeightedRandomBag loot = (WeightedRandomBag)((RecipeEntryTrommel)((SlotGuidebook)slot).recipe).getOutput();
                        int index = slot.index;
                        if (((SlotGuidebook)slot).recipeAmount > 8) {
                            index = slot.index + 9 * ((SlotGuidebook)slot).recipeIndex;
                        }
                        String s = (lootObject = (WeightedRandomLootObject)loot.getEntries().get(index)).isRandomYield() ? String.format("%d-%d", lootObject.getMinYield(), lootObject.getMaxYield()) : String.valueOf(lootObject.getFixedYield());
                        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, this.mc.font, this.mc.textureManager, itemStack, x, y, discovered ? s : "?", 1.0f);
                    } else {
                        itemModel.renderItemOverlayIntoGUI(Tessellator.instance, this.mc.font, this.mc.textureManager, itemStack, x, y, discovered ? null : "?", 1.0f);
                    }
                } else {
                    itemModel.renderItemOverlayIntoGUI(Tessellator.instance, this.mc.font, this.mc.textureManager, itemStack, x, y, discovered ? null : "?", 1.0f);
                }
            }
            GL11.glDisable(2929);
        }
        if (isSelected) {
            GL11.glDisable(2896);
            GL11.glDisable(2929);
            this.drawRect(x, y, x + 16, y + 16, -2130706433);
            GL11.glEnable(2896);
            GL11.glEnable(2929);
        }
        GL11.glDisable(32826);
        Lighting.disable();
        GL11.glDisable(2896);
        GL11.glDisable(2929);
    }

    public void render(ItemStack itemStack, int x, int y, boolean isSelected) {
        this.render(itemStack, x, y, isSelected, null);
    }

    public void render(ItemStack itemStack, int x, int y) {
        this.render(itemStack, x, y, false);
    }
}

