/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHandCannonLoaded
extends Item {
    public ItemHandCannonLoaded(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxDamage(100);
        this.maxStackSize = 1;
    }

    @Override
    @Nullable
    public ItemStack onUseItem(@NotNull ItemStack itemstack, @NotNull World world, @NotNull Player entityplayer) {
        world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * -0.2f - 0.4f));
        if (!world.isClientSide) {
            itemstack.damageItem(1, entityplayer);
            world.entityJoinedWorld(new ProjectileCannonball(world, entityplayer));
            if (itemstack.stackSize <= 0) {
                return null;
            }
            return new ItemStack(Items.HANDCANNON_UNLOADED, 1, itemstack.getMetadata(), itemstack.getData());
        }
        return itemstack;
    }
}

