/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import java.util.Random;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.jetbrains.annotations.NotNull;

public class WorldConfiguration {
    @NotNull
    private String worldName = "";
    private long numericSeed = new Random().nextLong();
    @NotNull
    private String stringSeed = "";
    private boolean cheatsEnabled = false;
    @NotNull
    private Gamemode gamemode = Gamemode.survival;
    @NotNull
    private WorldTypeGroups.Group worldTypeGroup = WorldTypeGroups.DEFAULT;
    @NotNull
    private final GameRuleCollection gameRuleCollection = new GameRuleCollection();

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public String getFinalWorldName() {
        if (MathHelper.stringNullOrLengthZero(this.worldName)) {
            return I18n.getInstance().translateKey("gui.create_world.label.new_world");
        }
        return this.worldName;
    }

    public void setWorldName(@NotNull String worldName) {
        this.worldName = worldName;
    }

    public long getNumericSeed() {
        return this.numericSeed;
    }

    public long getFinalNumericSeed() {
        if (MathHelper.stringNullOrLengthZero(this.stringSeed)) {
            return this.numericSeed;
        }
        try {
            long parsedSeed = Long.parseLong(this.stringSeed);
            if (parsedSeed != 0L) {
                return parsedSeed;
            }
        }
        catch (NumberFormatException e) {
            return this.stringSeed.hashCode();
        }
        return this.numericSeed;
    }

    public void regenNumericSeed() {
        this.numericSeed = new Random().nextLong();
    }

    @NotNull
    public String getStringSeed() {
        return this.stringSeed;
    }

    public void setStringSeed(@NotNull String seed) {
        this.stringSeed = seed;
    }

    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean cheatsEnabled) {
        this.cheatsEnabled = cheatsEnabled;
    }

    @NotNull
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(@NotNull Gamemode gamemode) {
        this.gamemode = gamemode;
    }

    @NotNull
    public WorldTypeGroups.Group getWorldTypeGroup() {
        return this.worldTypeGroup;
    }

    public void setWorldTypeGroup(@NotNull WorldTypeGroups.Group worldTypeGroup) {
        this.worldTypeGroup = worldTypeGroup;
    }

    @NotNull
    public GameRuleCollection getGameRuleCollection() {
        return this.gameRuleCollection;
    }

    @NotNull
    public String getFolderName(@NotNull ISaveFormat saveFormat) {
        char @NotNull [] ac = ChatAllowedCharacters.ALLOWED_CHARACTERS_ARRAY;
        @NotNull String folderName = this.worldName.trim();
        if (MathHelper.stringNullOrLengthZero(folderName)) {
            folderName = I18n.getInstance().translateKey("gui.create_world.label.new_world");
        }
        for (char c : ac) {
            folderName = folderName.replace(c, '_');
        }
        String fixedFolderName = folderName;
        int count = 1;
        while (saveFormat.getLevelData(folderName) != null) {
            folderName = fixedFolderName + " (" + count + ")";
            ++count;
        }
        return folderName;
    }
}

