/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    public static IntList displayLists = new IntArrayList();
    public static IntList textureNames = new IntArrayList();

    public static synchronized int generateDisplayLists(int range) {
        int list = GL11.glGenLists(range);
        displayLists.add(list);
        displayLists.add(range);
        return list;
    }

    public static synchronized void generateTextureNames(IntBuffer intbuffer) {
        GL11.glGenTextures(intbuffer);
        for (int i = intbuffer.position(); i < intbuffer.limit(); ++i) {
            textureNames.add(intbuffer.get(i));
        }
    }

    public static synchronized int generateTexture() {
        int tex = GL11.glGenTextures();
        textureNames.add(tex);
        return tex;
    }

    public static synchronized void deleteTexture(int tex) {
        GL11.glDeleteTextures(tex);
        for (int i = 0; i < textureNames.size(); ++i) {
            if (textureNames.getInt(i) != tex) continue;
            textureNames.removeInt(i);
            return;
        }
    }

    public static synchronized void deleteDisplayList(int displayList) {
        int displayListIndex = displayLists.indexOf(displayList);
        if (displayListIndex < 0) {
            return;
        }
        GL11.glDeleteLists(displayLists.getInt(displayListIndex), displayLists.getInt(displayListIndex + 1));
        displayLists.removeInt(displayListIndex);
        displayLists.removeInt(displayListIndex);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        for (int i = 0; i < displayLists.size(); i += 2) {
            GL11.glDeleteLists(displayLists.getInt(i), displayLists.getInt(i + 1));
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(textureNames.size());
        for (Integer textureName : textureNames) {
            intbuffer.put(textureName);
        }
        intbuffer.flip();
        GL11.glDeleteTextures(intbuffer);
        displayLists.clear();
        textureNames.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int i) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asIntBuffer();
    }

    public static FloatBuffer createDirectFloatBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asFloatBuffer();
    }
}

