/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.MobAge;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobDeer
extends MobAnimal
implements AgedMob {
    @NotNull
    private final MobAge age;
    @Nullable
    private Entity closestThreat;
    private int runawayTimer = 0;
    private int counter = 0;
    private boolean isRunningAway = false;
    private final int MAX_RUNAWAY_TIME = 200;
    private final int COUNTER_TIME = 30;
    public List<WeightedRandomLootObject> burningMobDrops = new ArrayList<WeightedRandomLootObject>();

    public MobDeer(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "deer");
        this.setSize(0.9f, 1.3f);
        this.moveSpeed = 0.8f;
        this.mobDrops.add(new WeightedRandomLootObject(Items.FOOD_VENISON_RAW.getDefaultStack(), 1, 2));
        this.burningMobDrops.add(new WeightedRandomLootObject(Items.FOOD_VENISON_COOKED.getDefaultStack(), 1, 2));
        this.age = MobAge.newRandom(this, 280, 14, 224);
        this.jumpHeight = 0.5;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.getMobAge().tick(this.world);
    }

    @Override
    public boolean hurt(@Nullable Entity attacker, int damage, DamageType type) {
        if (attacker != null) {
            this.beginRunaway();
        }
        return super.hurt(attacker, damage, type);
    }

    private void beginRunaway() {
        this.runawayTimer = 200;
        this.counter = 30;
        this.moveSpeed = 2.5f;
        this.findRandomPathToRunTo();
    }

    private void stopRunaway() {
        this.isRunningAway = false;
        this.counter = 0;
        this.moveSpeed = 0.4f;
    }

    @Override
    protected void updateAI() {
        super.updateAI();
        if (this.runawayTimer <= 0) {
            this.findThreatNearby();
            if (this.closestThreat != null) {
                this.beginRunaway();
            } else if (this.isRunningAway) {
                this.stopRunaway();
            }
        } else {
            this.isRunningAway = true;
            if (this.counter >= 0) {
                --this.counter;
            } else {
                this.findRandomPathToRunTo();
                this.counter = 30;
            }
            --this.runawayTimer;
        }
        if (this.isRunningAway && this.onGround && !this.isJumping && this.isWalking) {
            this.yd = 0.35;
            float f = this.yRot * 0.01745329f;
            this.xd -= (double)(MathHelper.sin(f) * 0.25f);
            this.zd += (double)(MathHelper.cos(f) * 0.25f);
        }
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.remainingFireTicks > 0) {
            return this.burningMobDrops;
        }
        return this.mobDrops;
    }

    protected void findThreatNearby() {
        List<MobWolf> nearbyWolves;
        int dist = 10;
        Player player = this.world.getClosestPlayer(this.x, this.y, this.z, dist);
        if (player != null && !player.isSneaking()) {
            this.closestThreat = player;
            return;
        }
        if (player == null && !(nearbyWolves = this.world.getEntitiesWithinAABB(MobWolf.class, AABB.fromPool(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).grow(8.0, 4.0, 8.0))).isEmpty()) {
            this.closestThreat = nearbyWolves.get(this.random.nextInt(nearbyWolves.size()));
            return;
        }
        this.closestThreat = null;
    }

    private void findRandomPathToRunTo() {
        if (this.closestThreat != null) {
            this.getPathAwayFromPoint(this.x + (double)this.random.nextInt(8) - 4.0, this.z + (double)this.random.nextInt(8) - 4.0, this.closestThreat.x, this.closestThreat.z);
        } else {
            this.getPathAwayFromPoint(this.x, this.z, this.x + (double)this.random.nextInt(8) - 4.0, this.z + (double)this.random.nextInt(8) - 4.0);
        }
    }

    protected void getPathAwayFromPoint(double x, double z, double pX, double pZ) {
        int scale = 10;
        double dX = x - pX;
        double dZ = z - pZ;
        double sqrt = Math.sqrt(dX * dX + dZ * dZ);
        double nDX = dX / sqrt;
        double nDZ = dZ / sqrt;
        Vec3 safePoint = Vec3.fromPool(x + nDX * (double)scale, this.y, z + nDZ * (double)scale);
        this.pathToEntity = this.world.getEntityPathToXYZ(this, MathHelper.floor(safePoint.x), MathHelper.floor(this.y), MathHelper.floor(safePoint.z), 16.0f);
    }

    @Override
    @NotNull
    public MobAge getMobAge() {
        return this.age;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("RunawayTimer", (short)this.runawayTimer);
        this.age.writeTag(tag);
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            return 4;
        }
        return 0;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.runawayTimer = tag.getShort("RunawayTimer");
        this.age.readTag(tag);
    }

    @Override
    public String getLivingSound() {
        return "mob.cow";
    }

    @Override
    protected String getHurtSound() {
        return "mob.cowhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.cowhurt";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }
}

