/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanGameRuleComponent
extends ButtonComponent {
    @Nullable
    private GameRuleCollection gameRuleCollection = null;
    private final GameRuleBoolean gameRule;
    private final SwitchElement button;

    public BooleanGameRuleComponent(GameRuleBoolean gameRule) {
        super(gameRule.getTranslationKey() + ".name", gameRule.getTranslationKey() + ".desc");
        this.gameRule = gameRule;
        this.button = new SwitchElement(0, 0, 0, 150, 20, (Boolean)this.gameRule.getDefaultValue(), I18n.getInstance().translateKey("gui.world_settings.page.game_rules.button.on"), I18n.getInstance().translateKey("gui.world_settings.page.game_rules.button.off"));
        this.button.setOn((Boolean)this.gameRule.getDefaultValue());
    }

    public void setGameRuleCollection(@NotNull GameRuleCollection collection) {
        this.gameRuleCollection = collection;
    }

    @Override
    public void resetValue() {
        this.gameRuleCollection.setValue(this.gameRule, (Boolean)this.gameRule.getDefaultValue());
        this.onChange();
    }

    @Override
    public void init(Minecraft mc) {
        this.onChange();
    }

    @Override
    public boolean isDefault() {
        return this.gameRuleCollection.getValue(this.gameRule).equals(this.gameRule.getDefaultValue());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.gameRuleCollection.setValue(this.gameRule, this.gameRuleCollection.getValue(this.gameRule) == false);
        this.onChange();
    }

    protected void onChange() {
        this.button.setOn(this.gameRuleCollection.getValue(this.gameRule));
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            BooleanGameRuleComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }
}

