/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.block.model.BlockModelTransparent;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelGlass<T extends BlockLogic>
extends BlockModelTransparent<T> {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected final IconCoordinate[] coordinates = new IconCoordinate[16];

    public BlockModelGlass(Block<T> block, @NotNull String rootKey) {
        super(block, false);
        this.coordinates[0] = TextureRegistry.getTexture(rootKey + "none");
        this.coordinates[1] = TextureRegistry.getTexture(rootKey + "up");
        this.coordinates[2] = TextureRegistry.getTexture(rootKey + "down");
        this.coordinates[4] = TextureRegistry.getTexture(rootKey + "left");
        this.coordinates[8] = TextureRegistry.getTexture(rootKey + "right");
        this.coordinates[3] = TextureRegistry.getTexture(rootKey + "up_down");
        this.coordinates[5] = TextureRegistry.getTexture(rootKey + "up_left");
        this.coordinates[9] = TextureRegistry.getTexture(rootKey + "up_right");
        this.coordinates[6] = TextureRegistry.getTexture(rootKey + "down_left");
        this.coordinates[10] = TextureRegistry.getTexture(rootKey + "down_right");
        this.coordinates[12] = TextureRegistry.getTexture(rootKey + "left_right");
        this.coordinates[7] = TextureRegistry.getTexture(rootKey + "up_down_left");
        this.coordinates[11] = TextureRegistry.getTexture(rootKey + "up_down_right");
        this.coordinates[13] = TextureRegistry.getTexture(rootKey + "up_left_right");
        this.coordinates[14] = TextureRegistry.getTexture(rootKey + "down_left_right");
        this.coordinates[15] = TextureRegistry.getTexture(rootKey + "up_down_left_right");
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        if (((Boolean)Minecraft.getMinecraft().gameSettings.connectedGlass.value).booleanValue()) {
            boolean r;
            boolean l;
            boolean d;
            boolean u;
            switch (side) {
                case SOUTH: {
                    u = blockAccess.getBlockId(x + Side.TOP.getOffsetX(), y + Side.TOP.getOffsetY(), z + Side.TOP.getOffsetZ()) == this.block.id();
                    d = blockAccess.getBlockId(x + Side.BOTTOM.getOffsetX(), y + Side.BOTTOM.getOffsetY(), z + Side.BOTTOM.getOffsetZ()) == this.block.id();
                    l = blockAccess.getBlockId(x + Side.WEST.getOffsetX(), y + Side.WEST.getOffsetY(), z + Side.WEST.getOffsetZ()) == this.block.id();
                    r = blockAccess.getBlockId(x + Side.EAST.getOffsetX(), y + Side.EAST.getOffsetY(), z + Side.EAST.getOffsetZ()) == this.block.id();
                    break;
                }
                case NORTH: {
                    u = blockAccess.getBlockId(x + Side.TOP.getOffsetX(), y + Side.TOP.getOffsetY(), z + Side.TOP.getOffsetZ()) == this.block.id();
                    d = blockAccess.getBlockId(x + Side.BOTTOM.getOffsetX(), y + Side.BOTTOM.getOffsetY(), z + Side.BOTTOM.getOffsetZ()) == this.block.id();
                    l = blockAccess.getBlockId(x + Side.EAST.getOffsetX(), y + Side.EAST.getOffsetY(), z + Side.EAST.getOffsetZ()) == this.block.id();
                    r = blockAccess.getBlockId(x + Side.WEST.getOffsetX(), y + Side.WEST.getOffsetY(), z + Side.WEST.getOffsetZ()) == this.block.id();
                    break;
                }
                case WEST: {
                    u = blockAccess.getBlockId(x + Side.TOP.getOffsetX(), y + Side.TOP.getOffsetY(), z + Side.TOP.getOffsetZ()) == this.block.id();
                    d = blockAccess.getBlockId(x + Side.BOTTOM.getOffsetX(), y + Side.BOTTOM.getOffsetY(), z + Side.BOTTOM.getOffsetZ()) == this.block.id();
                    l = blockAccess.getBlockId(x + Side.NORTH.getOffsetX(), y + Side.NORTH.getOffsetY(), z + Side.NORTH.getOffsetZ()) == this.block.id();
                    r = blockAccess.getBlockId(x + Side.SOUTH.getOffsetX(), y + Side.SOUTH.getOffsetY(), z + Side.SOUTH.getOffsetZ()) == this.block.id();
                    break;
                }
                case EAST: {
                    u = blockAccess.getBlockId(x + Side.TOP.getOffsetX(), y + Side.TOP.getOffsetY(), z + Side.TOP.getOffsetZ()) == this.block.id();
                    d = blockAccess.getBlockId(x + Side.BOTTOM.getOffsetX(), y + Side.BOTTOM.getOffsetY(), z + Side.BOTTOM.getOffsetZ()) == this.block.id();
                    l = blockAccess.getBlockId(x + Side.SOUTH.getOffsetX(), y + Side.SOUTH.getOffsetY(), z + Side.SOUTH.getOffsetZ()) == this.block.id();
                    r = blockAccess.getBlockId(x + Side.NORTH.getOffsetX(), y + Side.NORTH.getOffsetY(), z + Side.NORTH.getOffsetZ()) == this.block.id();
                    break;
                }
                default: {
                    u = blockAccess.getBlockId(x + Side.NORTH.getOffsetX(), y + Side.NORTH.getOffsetY(), z + Side.NORTH.getOffsetZ()) == this.block.id();
                    d = blockAccess.getBlockId(x + Side.SOUTH.getOffsetX(), y + Side.SOUTH.getOffsetY(), z + Side.SOUTH.getOffsetZ()) == this.block.id();
                    l = blockAccess.getBlockId(x + Side.WEST.getOffsetX(), y + Side.WEST.getOffsetY(), z + Side.WEST.getOffsetZ()) == this.block.id();
                    r = blockAccess.getBlockId(x + Side.EAST.getOffsetX(), y + Side.EAST.getOffsetY(), z + Side.EAST.getOffsetZ()) == this.block.id();
                }
            }
            return this.coordinates[(u ? 1 : 0) | (d ? 2 : 0) | (l ? 4 : 0) | (r ? 8 : 0)];
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }
}

