/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeFXOverworld
extends WorldTypeFX {
    public WorldTypeFXOverworld(WorldType worldType) {
        super(worldType);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float middle;
        float[] sunriseCol = new float[4];
        float sunriseMinimum = 0.4f;
        float sunrisePresence = MathHelper.cos(timeOfDay * (float)Math.PI * 2.0f);
        if (sunrisePresence >= (middle = 0.0f) - sunriseMinimum && sunrisePresence <= middle + sunriseMinimum) {
            float c = (sunrisePresence - middle) / sunriseMinimum * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * (float)Math.PI)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float b;
        float g;
        float r;
        float dayProgress = MathHelper.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        dayProgress = MathHelper.clamp(dayProgress, 0.0f, 1.0f);
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor(x);
            int y1 = MathHelper.floor(y);
            int z1 = MathHelper.floor(z);
            int color = Colorizers.fog.getColor(world, x1, y1, z1);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            r = 0.7529412f;
            g = 0.8470588f;
            b = 1.0f;
        }
        return Vec3.fromPool(r *= dayProgress * 0.94f + 0.06f, g *= dayProgress * 0.94f + 0.06f, b *= dayProgress * 0.91f + 0.09f);
    }
}

