/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import com.mojang.logging.LogUtils;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.betterthanadventure.sound.LibraryLWJGL3OpenAL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.enums.MusicFrequency;
import net.minecraft.client.gui.toasts.MusicToast;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.CodecMus;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;

public class SoundEngine {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static SoundSystem soundSystem;
    private static Lock lock;
    private static boolean loaded;
    public static final String BG_MUSIC = "BgMusic";
    public static final String STREAMING = "Streaming";
    private int idCounter = 0;
    @Nullable
    private GameSettings options;
    private final Random random = new Random();
    private Minecraft mc;
    public int ticksBeforeMusic;
    private boolean muted = false;

    public void resetMusicTicks() {
        this.ticksBeforeMusic = ((MusicFrequency)this.options.musicFrequency.value).interval == 0 ? 0 : this.random.nextInt(((MusicFrequency)this.options.musicFrequency.value).interval);
    }

    public void destroy() {
        try {
            lock.lock();
            if (this.isLoaded()) {
                soundSystem.cleanup();
                loaded = false;
                soundSystem = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setMuted(boolean muted) {
        try {
            lock.lock();
            if (!this.isLoaded()) {
                return;
            }
            this.muted = muted;
            if (this.muted) {
                soundSystem.setVolume(BG_MUSIC, 0.0f);
            } else {
                soundSystem.setVolume(BG_MUSIC, SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListener(Mob player, float partialTick) {
        try {
            lock.lock();
            if (!this.canPlaySounds()) {
                return;
            }
            if (player != null) {
                float yRot = MathHelper.lerp(player.yRotO, player.yRot, partialTick);
                double playerX = MathHelper.lerp(player.xo, player.x, (double)partialTick);
                double playerY = MathHelper.lerp(player.yo, player.y, (double)partialTick);
                double playerZ = MathHelper.lerp(player.zo, player.z, (double)partialTick);
                float yCos = MathHelper.cos(MathHelper.toRadians(-yRot - 180.0f));
                float ySin = MathHelper.sin(MathHelper.toRadians(-yRot - 180.0f));
                float xa = -ySin;
                float ya = 0.0f;
                float za = -yCos;
                float xa2 = 0.0f;
                float ya2 = 1.0f;
                float za2 = 0.0f;
                soundSystem.setListenerPosition((float)playerX, (float)playerY + player.getHeadHeight(), (float)playerZ);
                soundSystem.setListenerOrientation(xa, 0.0f, za, 0.0f, 1.0f, 0.0f);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void init(GameSettings gamesettings) {
        try {
            lock.lock();
            this.options = gamesettings;
            this.resetMusicTicks();
            if (!this.isLoaded() && SoundCategoryHelper.isAnyEnabled(gamesettings)) {
                this.loadLibrary();
            }
            this.mc = Minecraft.getMinecraft();
        }
        finally {
            lock.unlock();
        }
    }

    public void updateOptions() {
        try {
            lock.lock();
            if (!this.isLoaded()) {
                this.loadLibrary();
            }
            if (soundSystem != null && loaded) {
                if (SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
                    soundSystem.stop(BG_MUSIC);
                } else {
                    soundSystem.setVolume(BG_MUSIC, SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void tick() {
        try {
            lock.lock();
            if (!this.isLoaded() || SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) == 0.0f) {
                return;
            }
            if (!soundSystem.playing(BG_MUSIC) && !soundSystem.playing(STREAMING)) {
                if (this.ticksBeforeMusic > 0) {
                    --this.ticksBeforeMusic;
                    return;
                }
                SoundEvent event = this.mc != null && this.mc.thePlayer != null && !this.mc.thePlayer.world.canBlockSeeTheSky(MathHelper.floor(this.mc.thePlayer.x), MathHelper.floor(this.mc.thePlayer.y), MathHelper.floor(this.mc.thePlayer.z)) ? SoundRepository.SOUNDS.getSoundEvent("ambient.cave") : SoundRepository.SOUNDS.getRandomSoundFromCategory("music.");
                if (event == null) {
                    return;
                }
                SoundEntry entry = event.getRandomEntry();
                if (entry != null) {
                    this.resetMusicTicks();
                    this.ticksBeforeMusic += ((MusicFrequency)this.options.musicFrequency.value).interval;
                    soundSystem.backgroundMusic(BG_MUSIC, entry.getURL(), entry.name, false);
                    soundSystem.setPitch(BG_MUSIC, entry.pitch);
                    soundSystem.setVolume(BG_MUSIC, SoundCategoryHelper.getEffectiveVolume(SoundCategory.MUSIC, this.options) * entry.volume);
                    soundSystem.play(BG_MUSIC);
                    if (((Boolean)this.options.musicToasts.value).booleanValue() && entry.title != null) {
                        this.mc.guiToasts.addToast(new MusicToast(entry.title, entry.author));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while ticking sound engine!", e);
        }
        finally {
            lock.unlock();
        }
    }

    public void playSound(String name, SoundCategory category, float volume, float pitch) {
        this.playSound(SoundRepository.SOUNDS.getSoundEntry(name), category, volume, pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(SoundEntry entry, SoundCategory category, float volume, float pitch) {
        try {
            lock.lock();
            this.idCounter = (this.idCounter + 1) % 256;
            String soundName = "sound_" + this.idCounter;
            this.playSoundWithID(entry, category, volume, pitch, soundName);
        }
        finally {
            lock.unlock();
        }
    }

    public void playSoundAt(String name, SoundCategory category, float x, float y, float z, float volume, float pitch) {
        this.playSoundAt(SoundRepository.SOUNDS.getSoundEntry(name), category, x, y, z, volume, pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSoundAt(SoundEntry entry, SoundCategory category, float x, float y, float z, float volume, float pitch) {
        try {
            lock.lock();
            this.idCounter = (this.idCounter + 1) % 256;
            String soundName = "sound_" + this.idCounter;
            this.playSoundWithIdAtPos(entry, category, x, y, z, volume, pitch, soundName);
        }
        finally {
            lock.unlock();
        }
    }

    public void playSoundWithID(String name, SoundCategory category, float volume, float pitch, String soundID) {
        this.playSoundWithID(name, category, volume, pitch, soundID, true);
    }

    private void playSoundWithID(String name, SoundCategory category, float volume, float pitch, String soundID, boolean allowSubtitle) {
        this.playSoundWithID(SoundRepository.SOUNDS.getSoundEntry(name), category, volume, pitch, soundID, allowSubtitle);
    }

    public void playSoundWithID(SoundEntry entry, SoundCategory category, float volume, float pitch, String soundID) {
        this.playSoundWithID(entry, category, volume, pitch, soundID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSoundWithID(SoundEntry entry, SoundCategory category, float volume, float pitch, String soundID, boolean allowSubtitle) {
        try {
            lock.lock();
            if (entry != null) {
                if (this.canPlaySounds()) {
                    if (entry.type == SoundEntry.Type.FILE) {
                        URL url = entry.getURL();
                        if (url != null) {
                            if (entry.shouldStream) {
                                soundSystem.newStreamingSource(false, soundID, url, entry.name, false, 0.0f, 0.0f, 0.0f, 2, 0.0f);
                            } else {
                                soundSystem.newSource(false, soundID, url, entry.name, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
                            }
                            if (volume > 1.0f) {
                                volume = 1.0f;
                            }
                            soundSystem.setPitch(soundID, pitch * entry.pitch);
                            soundSystem.setVolume(soundID, (volume *= 0.25f) * SoundCategoryHelper.getEffectiveVolume(category, this.options) * entry.volume);
                            soundSystem.play(soundID);
                        }
                    } else if (entry.type == SoundEntry.Type.EVENT) {
                        this.playSoundWithID(entry.name, category, volume * entry.volume, pitch * entry.pitch, soundID, false);
                    }
                }
                if (allowSubtitle && entry.parent.hasSubtitle()) {
                    this.mc.subtitleTracker.heardSound(entry.parent, 0.0, 0.0, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while playing sound '{}' at {} {} {}!", (Object)entry, (Object)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void playSoundWithIdAtPos(String name, SoundCategory category, float x, float y, float z, float volume, float pitch, String soundID) {
        this.playSoundWithIdAtPos(name, category, x, y, z, volume, pitch, soundID, true);
    }

    private void playSoundWithIdAtPos(String name, SoundCategory category, float x, float y, float z, float volume, float pitch, String soundID, boolean allowSubtitle) {
        this.playSoundWithIdAtPos(SoundRepository.SOUNDS.getSoundEntry(name), category, x, y, z, volume, pitch, soundID, allowSubtitle);
    }

    public void playSoundWithIdAtPos(SoundEntry entry, SoundCategory category, float x, float y, float z, float volume, float pitch, String soundID) {
        this.playSoundWithIdAtPos(entry, category, x, y, z, volume, pitch, soundID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSoundWithIdAtPos(SoundEntry entry, SoundCategory category, float x, float y, float z, float volume, float pitch, String soundID, boolean allowSubtitle) {
        try {
            lock.lock();
            if (entry != null) {
                float soundDistance = entry.attenuationDistance;
                if (volume > 1.0f) {
                    soundDistance *= volume;
                }
                if (this.mc.activeCamera.distanceToSqr(x, y, z) > (double)(soundDistance * soundDistance)) {
                    return;
                }
                if (this.canPlaySounds()) {
                    if (entry.type == SoundEntry.Type.FILE) {
                        URL url = entry.getURL();
                        if (url != null) {
                            if (entry.shouldStream) {
                                soundSystem.newStreamingSource(volume > 1.0f, soundID, url, entry.name, false, x, y, z, 2, soundDistance);
                            } else {
                                soundSystem.newSource(volume > 1.0f, soundID, url, entry.name, false, x, y, z, 2, soundDistance);
                            }
                            if (volume > 1.0f) {
                                volume = 1.0f;
                            }
                            soundSystem.setPitch(soundID, pitch * entry.pitch);
                            soundSystem.setVolume(soundID, volume * SoundCategoryHelper.getEffectiveVolume(category, this.options) * entry.volume);
                            soundSystem.play(soundID);
                        }
                    } else if (entry.type == SoundEntry.Type.EVENT) {
                        this.playSoundWithIdAtPos(entry.name, category, x, y, z, volume * entry.volume, pitch * entry.pitch, soundID, false);
                    }
                }
                if (allowSubtitle && entry.parent.hasSubtitle()) {
                    this.mc.subtitleTracker.heardSound(entry.parent, x, y, z);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while playing sound '{}' at {} {} {}!", entry, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), e);
        }
        finally {
            lock.unlock();
        }
    }

    public void playMusic(String name, float x, float y, float z, float volume, float pitch) {
        this.playMusic(SoundRepository.SOUNDS.getSoundEntry(name), x, y, z, volume, pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playMusic(SoundEntry entry, float x, float y, float z, float volume, float pitch) {
        try {
            lock.lock();
            if (!this.canPlaySounds()) {
                return;
            }
            if (soundSystem.playing(STREAMING)) {
                soundSystem.stop(STREAMING);
            }
            if (entry == null) {
                return;
            }
            if (volume > 0.0f) {
                if (soundSystem.playing(BG_MUSIC)) {
                    soundSystem.stop(BG_MUSIC);
                }
                if (entry.type == SoundEntry.Type.FILE) {
                    URL url = entry.getURL();
                    if (url != null) {
                        soundSystem.newStreamingSource(true, STREAMING, url, entry.name, false, x, y, z, 2, (float)entry.attenuationDistance);
                        soundSystem.setPitch(STREAMING, pitch * entry.pitch);
                        soundSystem.setVolume(STREAMING, volume * entry.volume * ((Float)this.options.masterVolume.value).floatValue());
                        soundSystem.play(STREAMING);
                    }
                } else if (entry.type == SoundEntry.Type.EVENT) {
                    this.playMusic(entry.name, x, y, z, volume, pitch);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while playing music '{}' at {} {} {}!", entry, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), e);
        }
        finally {
            lock.unlock();
        }
    }

    public void stopMusic() {
        try {
            lock.lock();
            if (!this.isLoaded()) {
                return;
            }
            soundSystem.stop(BG_MUSIC);
            soundSystem.stop(STREAMING);
        }
        finally {
            lock.unlock();
        }
    }

    private void loadLibrary() {
        try {
            lock.lock();
            try {
                int i;
                float[] volumeStore = new float[SoundCategory.values().length];
                for (i = 0; i < SoundCategory.values().length; ++i) {
                    volumeStore[i] = SoundCategoryHelper.getVolume(SoundCategory.values()[i], this.options);
                }
                this.options.saveOptions();
                SoundSystemConfig.addLibrary(LibraryLWJGL3OpenAL.class);
                SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
                SoundSystemConfig.setCodec((String)"mus", CodecMus.class);
                SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
                soundSystem = new SoundSystem();
                for (i = 0; i < SoundCategory.values().length; ++i) {
                    SoundCategoryHelper.setVolume(SoundCategory.values()[i], this.options, volumeStore[i]);
                }
                this.options.saveOptions();
            }
            catch (Throwable throwable) {
                LOGGER.error("Error linking with the LibraryJavaSound plug-in", throwable);
            }
            loaded = true;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isLoaded() {
        return loaded && soundSystem != null;
    }

    private boolean canPlaySounds() {
        return this.isLoaded() && !this.muted && SoundCategoryHelper.isAnyEnabled(this.options);
    }

    @Nullable
    public static SoundSystem getSoundSystem() {
        return soundSystem;
    }

    static {
        lock = new ReentrantLock();
        loaded = false;
    }
}

