/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.collections;

import java.util.Objects;
import org.useless.seedviewer.collections.ChunkPos2D;

public final class ChunkPos3D
extends ChunkPos2D {
    public final int y;

    public ChunkPos3D(int x, int y, int z) {
        super(x, z);
        if (y < 0) {
            throw new IllegalArgumentException("Y must be between in range [0, 256]!");
        }
        if (y > 256) {
            throw new IllegalArgumentException("Y must be between in range [0, 256]!");
        }
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPos3D that = (ChunkPos3D)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    @Override
    public String toString() {
        return "ChunkPos3D{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

