/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelFluid<T extends BlockLogicFluid>
extends BlockModelStandard<T> {
    public BlockModelFluid(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, x, y, z, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        AABB bounds = this.block.getBlockBoundsFromState(worldSource, x, y, z);
        boolean renderTop = this.shouldSideBeRendered(worldSource, bounds, x, y + 1, z, Side.TOP);
        boolean flag1 = this.shouldSideBeRendered(worldSource, bounds, x, y - 1, z, Side.BOTTOM);
        boolean[] aflag = new boolean[]{this.shouldSideBeRendered(worldSource, bounds, x, y, z - 1, Side.NORTH), this.shouldSideBeRendered(worldSource, bounds, x, y, z + 1, Side.SOUTH), this.shouldSideBeRendered(worldSource, bounds, x - 1, y, z, Side.WEST), this.shouldSideBeRendered(worldSource, bounds, x + 1, y, z, Side.EAST)};
        if (!(renderTop || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean didRender = false;
        float sideBottom = 0.5f;
        float sideTop = 1.0f;
        float sideNorthSouth = 0.8f;
        float sideEastWest = 0.6f;
        float yOff = 0.001f;
        int meta = worldSource.getBlockMetadata(x, y, z);
        float f7 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, x, y, z);
        float f8 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, x, y, z + 1);
        float f9 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, x + 1, y, z + 1);
        float f10 = ((BlockLogicFluid)this.block.getLogic()).getFluidHeight(worldSource, x + 1, y, z);
        if (BlockModelFluid.renderBlocks.renderAllFaces || renderTop) {
            didRender = true;
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.TOP, meta);
            float rotation = (float)((BlockLogicFluid)this.block.getLogic()).getSlopeAngle(worldSource, x, y, z);
            if (rotation > -999.0f) {
                texture = this.getBlockTextureFromSideAndMetadata(Side.NORTH, meta);
            } else {
                rotation = 0.0f;
            }
            float blockBrightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                int light = this.block.getLightmapCoord(worldSource, x, y, z);
                int lightUp = this.block.getLightmapCoord(worldSource, x, y + 1, z);
                tessellator.setLightmapCoord(LightmapHelper.max(light, lightUp));
            } else {
                blockBrightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
            }
            if (texture.namespaceId.toString().contains("_flowing")) {
                double centerU = texture.getSubIconU(0.5);
                double centerV = texture.getSubIconV(0.5);
                float cSin = MathHelper.cos(rotation) / 2.0f;
                float sin = MathHelper.sin(rotation) / 2.0f;
                double minU = texture.getIconUMin();
                double maxU = texture.getIconUMax();
                double minV = texture.getIconVMin();
                double maxV = texture.getIconVMax();
                tessellator.setColorOpaque_F(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, (minU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, (maxU - centerU) * (double)sin - (maxV - centerV) * (double)cSin + centerU, (maxV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, (maxU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (maxU - centerU) * (double)cSin + centerV);
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, (minU - centerU) * (double)sin - (minV - centerV) * (double)cSin + centerU, (minV - centerV) * (double)sin + (minU - centerU) * (double)cSin + centerV);
            } else {
                tessellator.setColorOpaque_F(1.0f * blockBrightness * r, 1.0f * blockBrightness * g, 1.0f * blockBrightness * b);
                tessellator.addVertexWithUV(x, (float)y + f7, z, texture.getIconUMin(), texture.getIconVMax());
                tessellator.addVertexWithUV(x, (float)y + f8, z + 1, texture.getIconUMax(), texture.getIconVMax());
                tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, texture.getIconUMax(), texture.getIconVMin());
                tessellator.addVertexWithUV(x + 1, (float)y + f10, z, texture.getIconUMin(), texture.getIconVMin());
            }
        }
        if (BlockModelFluid.renderBlocks.renderAllFaces || flag1) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y - 1, z));
            } else {
                brightness = renderBlocks.getBlockBrightness(worldSource, x, y - 1, z);
            }
            tessellator.setColorOpaque_F(0.5f * brightness * r, 0.5f * brightness * g, 0.5f * brightness * b);
            renderBlocks.renderBottomFace(tessellator, bounds, x, (float)y + 0.001f, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
            didRender = true;
        }
        for (int side = 0; side < 4; ++side) {
            float f21;
            float f19;
            float f20;
            float f17;
            float f15;
            float f13;
            int xB = x;
            int yB = y;
            int zB = z;
            if (side == 0) {
                --zB;
            }
            if (side == 1) {
                ++zB;
            }
            if (side == 2) {
                --xB;
            }
            if (side == 3) {
                ++xB;
            }
            float uOff = side == 0 || side == 1 ? ((x & 1) == 0 ? 0.0f : 0.5f) : ((z & 1) == 0 ? 0.0f : 0.5f);
            IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.getSideById(side + 2), meta);
            if (!BlockModelFluid.renderBlocks.renderAllFaces && !aflag[side]) continue;
            if (side == 0) {
                f13 = f7;
                f15 = f10;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else if (side == 1) {
                f13 = f9;
                f15 = f8;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)(z + 1) - 0.001f;
            } else if (side == 2) {
                f13 = f8;
                f15 = f7;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else {
                f13 = f10;
                f15 = f9;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)(z + 1) - 1.0E-4f;
            }
            didRender = true;
            float vOff = (y & 1) == 0 ? 0.0f : 0.5f;
            double d4 = texture.getSubIconU(0.0f + uOff);
            double d5 = texture.getSubIconU(0.5f + uOff);
            double d6 = texture.getSubIconV(0.5f - f13 / 2.0f + vOff);
            double d7 = texture.getSubIconV(0.5f - f15 / 2.0f + vOff);
            double d8 = texture.getSubIconV(0.5f + vOff);
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, xB, yB, zB));
            } else {
                brightness = renderBlocks.getBlockBrightness(worldSource, xB, yB, zB);
            }
            brightness = side < 2 ? (brightness *= 0.8f) : (brightness *= 0.6f);
            tessellator.setColorOpaque_F(1.0f * brightness * r, 1.0f * brightness * g, 1.0f * brightness * b);
            tessellator.addVertexWithUV(f17, (float)y + f13, f19, d4, d6);
            tessellator.addVertexWithUV(f20, (float)y + f15, f21, d5, d7);
            tessellator.addVertexWithUV(f20, y, f21, d5, d8);
            tessellator.addVertexWithUV(f17, y, f19, d4, d8);
        }
        return didRender;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, @NotNull Side side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.block.getMaterial()) {
            return false;
        }
        if (material == Material.ice) {
            return true;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }
}

